//+------------------------------------------------------------------+
//|               Breakdowning martingail v 1.0.2.mq4               | 
//|                  Copyright  2006, B@ss & Steve                  | 
//|                        albass@mail333.com                        | 
//+------------------------------------------------------------------+
#property copyright "Copyright  2006, B@ss & Steve"
#property link      "albass@mail333.com, http://forum.alpari-idc.ru"
//----
#include <stdlib.mqh>
//  false,     ,     
extern bool   TradeAllowed        = true;
//   
extern int    Step                = 18;
extern string _                   = " MoneyManagement";
//   ,   
extern double startLots           = 0.1;
//  MoneyManagement
extern bool   MoneyManagement     = true;
//  MoneyManagement
extern bool   LogariphmicMM       = true;
//      
extern double Riskfactor          = 6;
//       
extern double ProfitPercent       = 2;
//     ( )
extern bool   OptimalTakeProfit   = true;
extern string __                  = "  ";
//    (0 -      , 
// 1 - ,     )
extern int    mode_work           = 0;
// -  ,    ( 0,  )                                           
extern int    TrailingStop        = 30;
//       
extern bool   NoTradeBeforeNewDay = true;
//    Step
//   0 -   Step
//   1 -   15,   40
//   2 -     FreeMargin  15  40
extern int    MinMaxStepMode      = 0;
//                                                       
extern bool   ShowLog             = false;
//----
int    timeOut      = 5000;
int    maxLevel     = 9;     //  
double LotsLevel_2  = 1;     //     
double LotsLevel_3  = 2;
double LotsLevel_4  = 4;
double LotsLevel_5  = 6;
double LotsLevel_6  = 10;
double LotsLevel_7  = 16;
double LotsLevel_8  = 26;
double LotsLevel_9  = 42;
double LotsLevel_10 = 64;
double LotsLevel_11 = 100;
double LotsLevel_12 = 168;
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+        
int init()
  {
   ObjectCreate("label_object", OBJ_LABEL, 0, 0, 0);  
   ObjectCreate("label_object1", OBJ_LABEL, 0, 0, 0);
   ObjectCreate("label_object2", OBJ_LABEL, 0, 0, 0); 
   ObjectSet("label_object", OBJPROP_XDISTANCE, 11);  
   ObjectSet("label_object", OBJPROP_YDISTANCE, 14);
   ObjectSet("label_object1", OBJPROP_XDISTANCE, 400);
   ObjectSet("label_object1", OBJPROP_YDISTANCE, 20);
   ObjectSet("label_object2", OBJPROP_XDISTANCE, 400);  
   ObjectSet("label_object2", OBJPROP_YDISTANCE, 35);
   ObjectSetText("label_object", "Breakdowning Martingail  version 1.0.2",
                 11, "Verdana", White);
   return(0);
  }
//+------------------------------------------------------------------+
//|             |
//+------------------------------------------------------------------+
bool isMgNum(int num) 
  {
   int t, cnt1;
   t = OrdersTotal();
   for(cnt1 = 0; cnt1 < t; cnt1++)
     {
       OrderSelect(cnt1, SELECT_BY_POS, MODE_TRADES);
       if(OrderMagicNumber() == num && OrderSymbol() == Symbol())
         {
           return(True);//  
         }
     }  
   return (False);   
  }
//+------------------------------------------------------------------+
//|                          |
//+------------------------------------------------------------------+
bool deleteOrderNum(int num) 
  {       
   int t, cnt1, err;     
   bool tic;
   t = OrdersTotal();
   for(cnt1 = 0; cnt1 < t; cnt1++)
     {
       OrderSelect(cnt1, SELECT_BY_POS, MODE_TRADES);
       if(OrderSymbol() == Symbol())
         {
           //         
           if(OrderMagicNumber() == num && (OrderType() == OP_BUYSTOP || 
              OrderType() == OP_SELLSTOP || OrderType() == OP_SELLLIMIT || 
              OrderType() == OP_BUYLIMIT))            
             {
               int start = GetTickCount();
               tic = OrderDelete(OrderTicket());               
               if(ShowLog)
                 {
                   Print("  ", (GetTickCount() - start) / 1000, " .");
                 }
               if(tic) 
                   PlaySound("timeout.wav");
               if(!tic) 
                 {
                   err = GetLastError();
                   Print(" = ", err, " (", ErrorDescription(err), ")");
                 } 
               return(True); //  
             }
         }   
     }  
   return (False);   
  }     
//+------------------------------------------------------------------+
//|  , ,          |
//|                                                           |
//+------------------------------------------------------------------+
bool isOrderActive(int num)  //     
  {       
   int t, cnt1;     
   t = OrdersTotal();
   for(cnt1 = 0; cnt1 < t; cnt1++)
     {
       OrderSelect(cnt1, SELECT_BY_POS, MODE_TRADES);
       if(OrderSymbol() == Symbol())
         {       
           if(OrderMagicNumber() == num) 
             {     
               if(OrderType() == OP_BUY || OrderType() == OP_SELL)
                 {
                   return(True);//  
                 }
             }
         }
     }  
   return (False);   
  } 
//+------------------------------------------------------------------+
//|         |
//+------------------------------------------------------------------+
int getTopLevel(int mode)  //     
  {       
   int t, cnt1, tLev, cLev;
   t = OrdersTotal();
   cLev = 0;
   tLev = 0;
   for(cnt1 = 0; cnt1 < t; cnt1++)
     {
       OrderSelect(cnt1, SELECT_BY_POS, MODE_TRADES);
       if(OrderSymbol() == Symbol())
         {
           if(OrderType() == OP_BUY || OrderType() == OP_SELL)
             { 
               //  
               if(mode == 1)
                 {  
                   //   
                   if(OrderMagicNumber() == 881) 
                       cLev = 12;
                   if(OrderMagicNumber() == 871) 
                       cLev = 11;
                   if(OrderMagicNumber() == 861) 
                       cLev = 10;
                   if(OrderMagicNumber() == 851) 
                       cLev = 9;
                   if(OrderMagicNumber() == 841) 
                       cLev = 8;
                   if(OrderMagicNumber() == 831) 
                       cLev = 7;
                   if(OrderMagicNumber() == 821) 
                       cLev = 6;
                   if(OrderMagicNumber() == 811) 
                       cLev = 5;
                   if(OrderMagicNumber() == 801) 
                       cLev = 4;
                   if(OrderMagicNumber() == 791) 
                       cLev = 3;
                   if(OrderMagicNumber() == 781) 
                       cLev = 2;
                   if(OrderMagicNumber() == 771) 
                       cLev = 1;
                 } 
               else 
                 {  
                   //   
                   if(OrderMagicNumber() == 882) 
                       cLev = 12;
                   if(OrderMagicNumber() == 872) 
                       cLev = 11;
                   if(OrderMagicNumber() == 862) 
                       cLev = 10;
                   if(OrderMagicNumber() == 852) 
                       cLev = 9;
                   if(OrderMagicNumber() == 842) 
                       cLev = 8;
                   if(OrderMagicNumber() == 832) 
                       cLev = 7;                                             
                   if(OrderMagicNumber() == 822) 
                       cLev = 6;
                   if(OrderMagicNumber() == 812) 
                       cLev = 5;
                   if(OrderMagicNumber() == 802) 
                       cLev = 4;
                   if(OrderMagicNumber() == 792) 
                       cLev = 3;
                   if(OrderMagicNumber() == 782) 
                       cLev = 2;
                   if(OrderMagicNumber() == 772) 
                       cLev = 1;             
                 }
             }   
         }
       if(cLev > tLev) 
           tLev = cLev;   
     }  
   return(tLev);   
  }
//+------------------------------------------------------------------+
//|  ,        |
//+------------------------------------------------------------------+
double getLotByLevel(int level) //      
  {       
    double lot1;
    lot1 = startLots;  //    
    if(level == 1) 
        //   -    ,   0,1 
        lot1 = 0.1; 
    if(level == 2) 
        lot1 = NormalizeDouble(startLots*LotsLevel_2, 1);
    if(level == 3) 
        lot1 = NormalizeDouble(startLots*LotsLevel_3, 1);
    if(level == 4) 
        lot1 = NormalizeDouble(startLots*LotsLevel_4, 1);
    if(level == 5) 
        lot1 = NormalizeDouble(startLots*LotsLevel_5, 1);
    if(level == 6) 
        lot1 = NormalizeDouble(startLots*LotsLevel_6, 1);
    if(level == 7) 
        lot1 = NormalizeDouble(startLots*LotsLevel_7, 1);
    if(level == 8) 
        lot1 = NormalizeDouble(startLots*LotsLevel_8, 1);
    if(level == 9) 
        lot1 = NormalizeDouble(startLots*LotsLevel_9, 1);         
    if(level == 10) 
        lot1 = NormalizeDouble(startLots*LotsLevel_10, 1);         
    if(level == 11) 
        lot1 = NormalizeDouble(startLots*LotsLevel_11, 1);
    if(level == 12) 
        lot1 = NormalizeDouble(startLots*LotsLevel_12, 1);
   return(lot1);   
  }
//+------------------------------------------------------------------+
//|          |
//+------------------------------------------------------------------+
double getOrderPriceByNum(int num) 
  {       
   int t, cnt1;     
   t = OrdersTotal();
   for(cnt1 = 0; cnt1 < t; cnt1++)
     {
       OrderSelect(cnt1, SELECT_BY_POS, MODE_TRADES);
       if(OrderSymbol() == Symbol())
         {       
           if(OrderMagicNumber() == num) 
             {     
               return(OrderOpenPrice());
             }
         }
     }  
   return (0);   
  }
//+------------------------------------------------------------------+
//|             |
//|                                                            |
//+------------------------------------------------------------------+
datetime getOrderOpenTimeByNum (int num)
  {       
   int t, cnt1;     
   t = OrdersTotal();
   for(cnt1 = 0; cnt1 < t; cnt1++)
     {
       OrderSelect(cnt1, SELECT_BY_POS, MODE_TRADES);
       if(OrderSymbol() == Symbol())
         {       
           if(OrderMagicNumber() == num) 
             {     
               return(OrderOpenTime());
             }
         }
      }  
   return (0);   
  }      
//+------------------------------------------------------------------+
//|           |
//+------------------------------------------------------------------+
double getBuyLotsSum(int mode)
  {
   int t, cnt1;
   double sm;
   t = OrdersTotal();
   sm = 0;
   for(cnt1 = 0; cnt1 < t; cnt1++)
     {
       OrderSelect(cnt1, SELECT_BY_POS, MODE_TRADES);
       if(mode != 1) 
         {     
           if(OrderType() == OP_BUY && OrderSymbol() == Symbol())
             {
               sm = sm + OrderLots();
             }
         } 
       else 
         { 
           //       
           if(OrderType() == OP_BUY)
             {
               sm = sm + OrderLots();
             }          
         }        
     }   
   return(sm);     
  }
//+------------------------------------------------------------------+
//|           |
//+------------------------------------------------------------------+
double getSellLotsSum(int mode)
  {
   int t, cnt1;
   double sm;
   t = OrdersTotal();
   sm = 0;
   for(cnt1 = 0; cnt1 < t; cnt1++)
     {
       OrderSelect(cnt1, SELECT_BY_POS, MODE_TRADES);
       if(mode != 1) 
         {                
           if(OrderType() == OP_SELL && OrderSymbol() == Symbol())
             {
               sm = sm + OrderLots();
             }
         } 
       else 
         {
           //       
           if(OrderType() == OP_SELL)
             {
               sm = sm + OrderLots();
             }          
         }    
     }   
   return(sm);     
  }
//+------------------------------------------------------------------+
//|                 |
//|           |
//|                                                            |
//+------------------------------------------------------------------+
int getMaxLongNum()
  {
   int t, cnt1;
   int topL;    
   t = OrdersTotal();
   topL = 0;
   for(cnt1 = 0; cnt1 < t; cnt1++)
     {
       OrderSelect(cnt1, SELECT_BY_POS, MODE_TRADES);
       if(OrderSymbol() == Symbol())
         {     
           if(OrderType() == OP_BUY)
             {
               if(OrderMagicNumber() > topL) 
                   topL = OrderMagicNumber();
             }
         }
     }  
   return (topL);      
  }
//+------------------------------------------------------------------+
//|             |
//|                                                   |
//+------------------------------------------------------------------+
int getMaxShortNum()
  {
   int t, cnt1;
   int topL;    
   t = OrdersTotal();
   topL = 0;
   for(cnt1 = 0; cnt1 < t; cnt1++)
     {
       OrderSelect(cnt1, SELECT_BY_POS, MODE_TRADES);
       if(OrderSymbol() == Symbol())
         {     
           if(OrderType() == OP_SELL)
             {
               if(OrderMagicNumber() > topL) 
                   topL = OrderMagicNumber();
             }
         }
     }  
   return (topL);      
  }
//+------------------------------------------------------------------+
//|                |
//+------------------------------------------------------------------+
int getNextOrderNum(int n1)
  {        
   if(n1 == 771) 
       return (781);
   if(n1 == 781) 
       return (791);
   if(n1 == 791) 
       return (801);
   if(n1 == 801) 
       return (811);
   if(n1 == 811) 
       return (821);
   if(n1 == 821) 
       return (831);
   if(n1 == 831) 
       return (841);
   if(n1 == 841) 
       return (851);        
   if(n1 == 851) 
       return (861);
   if(n1 == 861) 
       return (871);
   if(n1 == 871) 
       return (881);
   if(n1 == 772) 
       return (782);
   if(n1 == 782) 
       return (792);
   if(n1 == 792) 
       return (802);
   if(n1 == 802) 
       return (812); 
   if(n1 == 812) 
       return (822);
   if(n1 == 822) 
       return (832); 
   if(n1 == 832) 
       return (842); 
   if(n1 == 842) 
       return (852); 
   if(n1 == 852) 
       return (862); 
   if(n1 == 862) 
       return (872); 
   if(n1 == 872) 
       return (882); 
   return (0);       
  }    
//+------------------------------------------------------------------+
//|                  |
//+------------------------------------------------------------------+
int getNum(int dir, int level)
  {
   if(dir == 1)
     {
       // 
       if(level == 1) 
           return(771);
       if(level == 2) 
           return(781);
       if(level == 3) 
           return(791);
       if(level == 4) 
           return(801);
       if(level == 5) 
           return(811);
       if(level == 6) 
           return(821);
       if(level == 7) 
           return(831);
       if(level == 8) 
           return(841);
       if(level == 9) 
           return(851);
       if(level == 10) 
           return(861);
       if(level == 11) 
           return(871);
       if(level == 12) 
           return(881);
     } 
   else 
     {
       if(level == 1) 
           return(772);
       if(level == 2) 
           return(782);
       if(level == 3) 
           return(792);
       if(level == 4) 
           return(802);
       if(level == 5) 
           return(812);
       if(level == 6) 
           return(822);
       if(level == 7) 
           return(832);
       if(level == 8) 
           return(842);
       if(level == 9) 
           return(852);        
       if(level == 10) 
           return(862);        
       if(level == 11) 
           return(872);        
       if(level == 12) 
           return(882);        
     }     
  }     
//+------------------------------------------------------------------+
//|                               |
//+------------------------------------------------------------------+
//         
//          
// ,  .
int modOrder(int num, double oprice, double prprice)
  {
   int t, cnt1, err, start;
   bool tic;
   double p1, p2;
   t = OrdersTotal();
   for(cnt1 = 0; cnt1 < t; cnt1++)
     {
       OrderSelect(cnt1, SELECT_BY_POS, MODE_TRADES);
       if(OrderSymbol() == Symbol() && OrderMagicNumber() == num)
         { 
           if((OrderOpenPrice() != oprice || OrderTakeProfit() != prprice) && 
               oprice != 0) 
             {     
               if(OrderType() == OP_BUYSTOP || OrderType() == OP_SELLLIMIT)
                 {
                   p1 = oprice;
                   p2 = prprice;
                   NormalizeDouble(p2, MarketInfo(Symbol(), MODE_DIGITS));
                   NormalizeDouble(p1, MarketInfo(Symbol(), MODE_DIGITS));
                   if(NormalizeDouble(OrderOpenPrice(), Digits) != 
                      NormalizeDouble(p1, Digits) || 
                      NormalizeDouble(OrderTakeProfit(), Digits) != 
                      NormalizeDouble(p2, Digits)) 
                     {                  
                       start = GetTickCount();
                       tic = OrderModify(OrderTicket(), p1, 0, p2, 0, Green);
                       if(ShowLog)
                         {
                           Print(" BUYSTOP ", OrderOpenPrice(), "->", p1,
                                 " t/p ", OrderTakeProfit(), "->", p2);
                           Print("  ", (GetTickCount() - start) / 1000,
                                 " .");  
                         }
                       if(tic) 
                           PlaySound("alert.wav");                    
                       if(!tic) 
                         {
                           err = GetLastError(); 
                           Print(" = ", err, " (", ErrorDescription(err), ")");
                         }                     
                       Sleep(timeOut);
                     }
                 }
               if(OrderType() == OP_SELLSTOP || OrderType() == OP_BUYLIMIT)
                 {
                   p1 = oprice;
                   p2 = prprice;
                   NormalizeDouble(p2, MarketInfo(Symbol(), MODE_DIGITS));
                   NormalizeDouble(p1, MarketInfo(Symbol(), MODE_DIGITS));
                   if(NormalizeDouble(OrderOpenPrice(), Digits) != 
                      NormalizeDouble(p1, Digits) || 
                      NormalizeDouble(OrderTakeProfit(), Digits) != 
                      NormalizeDouble(p2, Digits)) 
                     { 
                       start = GetTickCount();
                       tic = OrderModify(OrderTicket(), p1, 0, p2, 0, Green);
                       if(ShowLog)
                         {
                           Print(" SELLSTOP ", OrderOpenPrice(), "->", p1, 
                                 " t/p ", OrderTakeProfit(),"->", p2);
                           Print("  ", (GetTickCount() - start) / 1000,
                                 " .");  
                         }
                       if(tic) 
                           PlaySound("alert.wav");                      
                       if(!tic) 
                         {
                           err = GetLastError(); 
                           Print(" = ", err, " (", ErrorDescription(err), ")");
                         }                       
                       Sleep(timeOut);
                     }                       
                 }              
             }            
         }
     }  
   return (1);      
  }    
//+------------------------------------------------------------------+
//|         : |
//| mode=1    ,     |
//|                                                      |
//+------------------------------------------------------------------+
double getAllProfit(int mode)
  {
   int t, cnt1;
   double pf;
   t = OrdersTotal();
   pf = 0;
   for(cnt1 = 0; cnt1 < t; cnt1++)
     {
       OrderSelect(cnt1, SELECT_BY_POS, MODE_TRADES);
       if(mode == 1)
         {      
           if(OrderSymbol() == Symbol() && (OrderType() == OP_BUY || 
              OrderType() == OP_SELL))
             {
               pf = pf + OrderProfit() + OrderSwap() + OrderCommission();           
             }
         } 
       else 
         {
           if(mode == 2 && OrderSymbol() == Symbol() && OrderType() == OP_BUY) 
             {
               pf = pf + OrderProfit() + OrderSwap() + OrderCommission();
             }
           if(mode == 3 && OrderSymbol() == Symbol() && OrderType() == OP_SELL)
             {
               pf = pf + OrderProfit() + OrderSwap() + OrderCommission();                        
             }   
         }
     }  
   return (pf);           
  }
//+------------------------------------------------------------------+
//|                                 |
//+------------------------------------------------------------------+
double getDayProfit(int mode, int dayShift)
  {
   int t, cnt1, cyear, cmonth, cday;
   double pf;
   datetime ctm;
   t = HistoryTotal();
   pf = 0;
   for(cnt1 = 0; cnt1 < t; cnt1++)
     {
       OrderSelect(cnt1, SELECT_BY_POS, MODE_HISTORY);
       ctm = OrderCloseTime();
       cyear = TimeYear(ctm);
       cmonth = TimeMonth(ctm);
       cday = TimeDay(ctm);
       if(cyear == Year() && cmonth == Month() && cday == (Day() - dayShift))
         {                 
           if(mode == 1)
             {      
               //    
               if(OrderType() == OP_BUY || OrderType() == OP_SELL) 
                 {
                   pf = pf + OrderProfit() + OrderSwap() + OrderCommission();           
                 }
             } 
           else 
             {
               if(mode == 2 && OrderType() == OP_BUY) 
                 { 
                   //   
                   pf = pf + OrderProfit() + OrderSwap() + OrderCommission();
                 }
               if(mode == 3 && OrderType() == OP_SELL)
                 { 
                   //   
                   pf = pf + OrderProfit() + OrderSwap() + OrderCommission();                        
                 }   
             }      
         } 
     }  
   return (pf);           
  }
//+------------------------------------------------------------------+
//|   ,     SellStop             |
//+------------------------------------------------------------------+
double setPriceSellStop()
  {
   double topPrice, PriceSetka, HighestPriceInRange;
   int NumPoloski, NumBarsAfterOpenedOrder;
   datetime OpenOrderTime;
   if(mode_work == 0)
     {
       topPrice = getOrderPriceByNum(getMaxShortNum());
       OpenOrderTime = getOrderOpenTimeByNum(getMaxShortNum());
     }
   if(mode_work ==1 )
     {
       topPrice = getOrderPriceByNum(getMaxLongNum());
       OpenOrderTime = getOrderOpenTimeByNum(getMaxLongNum());
     }
   NumBarsAfterOpenedOrder = iBarShift(NULL, 0, OpenOrderTime, false);         
   HighestPriceInRange = Highest(NULL, 0, MODE_HIGH, NumBarsAfterOpenedOrder, 0);
//      BID
   NumPoloski = MathAbs(MathFloor((Bid - topPrice) / (Step*Point)));
//  ,    
   PriceSetka = topPrice + NumPoloski*Step*Point;
   if(HighestPriceInRange < PriceSetka + Step*Point && 
      PriceSetka >= topPrice + Step*Point && Bid > topPrice)   
     {
       return(NormalizeDouble(PriceSetka - Step*Point, Digits));
     }                
  }
//+------------------------------------------------------------------+
//|  ,     BuyStop               |
//+------------------------------------------------------------------+
double setPriceBuyStop()
  {
   double lowPrice, PriceSetka, LowestPriceInRange;
   int NumPoloski, NumBarsAfterOpenedOrder;
   datetime OpenOrderTime;
   if(mode_work == 0)
     {         
       lowPrice = getOrderPriceByNum(getMaxLongNum());
       OpenOrderTime = getOrderOpenTimeByNum(getMaxLongNum());
     }
   if(mode_work == 1)
     {
       lowPrice = getOrderPriceByNum(getMaxShortNum());
       OpenOrderTime = getOrderOpenTimeByNum(getMaxShortNum());
     }
   NumBarsAfterOpenedOrder = iBarShift(NULL, 0, OpenOrderTime, false);         
   LowestPriceInRange = Lowest(NULL, 0, MODE_LOW, NumBarsAfterOpenedOrder, 0);
//      ASK
   NumPoloski = MathAbs(MathFloor((lowPrice - Ask) / (Step*Point)));

   PriceSetka = lowPrice - NumPoloski*Step*Point;
//  ,       
   if(LowestPriceInRange > PriceSetka - Step*Point && 
      PriceSetka <= lowPrice - Step*Point && Ask < lowPrice)   
     {
       return(NormalizeDouble(PriceSetka + Step*Point,Digits));
     }
  }
//+------------------------------------------------------------------+
//|                         |
//+------------------------------------------------------------------+
bool getProfitOrdersClose()
  {
   int cnt1, err, tic1,tic2, LotBy, LotBy1, i;
   bool ticdone;    
   int T_sell[10], T_buy[10], a;  
   a = 0;
   for(cnt1 = 0; cnt1 < OrdersTotal(); cnt1++)
     {
       //,        
       OrderSelect(cnt1, SELECT_BY_POS);         
       tic1 = OrderTicket(); 
       LotBy = OrderLots();
       if(OrderType() == OP_SELL)
         {           
           for(i = 0; i < OrdersTotal(); i++)
             {
               OrderSelect(i, SELECT_BY_POS);             
               tic2 = OrderTicket(); 
               LotBy1 = OrderLots();
               if(OrderType() == OP_BUY && LotBy == LotBy1 && 
                  OrderSelect(tic1, SELECT_BY_TICKET) && 
                  OrderSelect(tic2, SELECT_BY_TICKET))
                 {                
                   T_sell[a] = tic1;
                   T_buy[a] = tic2;                    
                   a++;
                 }
             }
         }
     } 
   for(cnt1 = 0; cnt1 < a; cnt1++)
     {
       //   
       if(OrderSelect(T_sell[cnt1], SELECT_BY_TICKET) && 
          OrderSelect(T_buy[cnt1], SELECT_BY_TICKET))
         {
           ticdone = OrderCloseBy(T_sell[cnt1], T_buy[cnt1], Green);        
           if(!ticdone)
             {
               err = GetLastError(); 
               Print("    = ", ErrorDescription(err), 
                     "  (sell)= ", T_sell[cnt1], "  (buy)= ", T_buy[cnt1]);
             }            
         }
     }   
   for(cnt1 = OrdersTotal(); cnt1 >= 0; cnt1--)
     {
       //    
       OrderSelect(cnt1, SELECT_BY_POS, MODE_TRADES);
       if(OrderSymbol() == Symbol())
         {
           if(OrderType() == OP_BUY)
             {
               ticdone = OrderClose(OrderTicket(), OrderLots(), Ask, 5, Green);
               if(ticdone) 
                   PlaySound("timeout.wav");
               if(!ticdone)
                 {
                   err = GetLastError(); 
                   if(err != 0) 
                   Print("   = ", ErrorDescription(err));
                 }            
             }
           if(OrderType() == OP_SELL)
             {
               ticdone = OrderClose(OrderTicket(), OrderLots(), Bid, 5, Green);
               if(ticdone) 
                   PlaySound("timeout.wav");
               if(!ticdone)
                 {
                   err = GetLastError(); 
                   if(err != 0) 
                       Print("   = ", ErrorDescription(err));
                 }           
             }
         }
     }  
   return (False);       
  }
//+------------------------------------------------------------------+
//|             |
//|                                      |
//+------------------------------------------------------------------+
double getSumWeightedPrice(int mode)
  {
   int i;
   double sumWeightedPrice;
   for(i=0;i<=OrdersTotal();i++)
     {
       OrderSelect(i,SELECT_BY_POS);
       if(OrderType() == OP_BUY && mode == 1)
         {
           sumWeightedPrice = sumWeightedPrice + OrderLots()*OrderOpenPrice();
         }
       if(OrderType() == OP_SELL && mode == 2)
         {
           sumWeightedPrice = sumWeightedPrice+OrderLots()*OrderOpenPrice();
         }   
      }
   return(sumWeightedPrice);
  }
//+------------------------------------------------------------------+
//|     ,            |
//|                      |
//+------------------------------------------------------------------+
double getOptimalTakeProfit(double multiplier, bool SELL_BUY)
  {
//    
   double TempOptimalTP, TempOptimalTP_sell, TempOptimalTP_buy, NeedTP_points, lots;
   int i;
   double profit_money, price_tick;    
   profit_money = AccountBalance()*ProfitPercent*multiplier / 100;
   price_tick = MarketInfo(Symbol(), MODE_TICKVALUE);
//    ( =1)   
   NeedTP_points = profit_money*Point / price_tick;
   lots = getBuyLotsSum(1) + getSellLotsSum(1);
   if(getSellLotsSum(1) != 0)   
     {
       TempOptimalTP_sell = (getSumWeightedPrice(2) - NeedTP_points) / getSellLotsSum(1);
     }
   else 
     {
       //     
       TempOptimalTP_sell = 0;
     }
   if(getBuyLotsSum(1) != 0)   
     {
       TempOptimalTP_buy = (getSumWeightedPrice(1) + NeedTP_points) / getBuyLotsSum(1);
     }
   else 
     {
       //     
       TempOptimalTP_buy = 0;
     }             
   if(!SELL_BUY)
     {  
       if(getBuyLotsSum(1) == getSellLotsSum(1))
         {
           TempOptimalTP = TempOptimalTP_buy;
         }
       else
         {  
           if(lots != 0)
             {
               TempOptimalTP = (TempOptimalTP_buy*getBuyLotsSum(1) + 
                                TempOptimalTP_sell*getSellLotsSum(1) + 
                                NeedTP_points) / lots;
             }
           else 
             {
               TempOptimalTP = 0;
             }
         }                 
       //    
       return(NormalizeDouble(TempOptimalTP_buy, Digits));
     }
   if(SELL_BUY)
     {  
       if(getBuyLotsSum(1) == getSellLotsSum(1))
         {
           TempOptimalTP = TempOptimalTP_sell;
         }
       else
         {  
           if(lots != 0)
             {
               TempOptimalTP = (TempOptimalTP_buy*getBuyLotsSum(1) + 
                                TempOptimalTP_sell*getSellLotsSum(1) - 
                                NeedTP_points) / lots;
             }
           else 
             {
               TempOptimalTP = 0;
             }
         }                
       //    
       return(NormalizeDouble(TempOptimalTP_sell,Digits));           
     }           
  }   
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void setPendingOrders(int mode)
  {
   int i, start, err;
   bool ticket;
   double lot;
//  
   if(mode == 0)
     {
       //   
       if(getTopLevel(1) < maxLevel && !isMgNum(100))
         {   
           for(i = 1; i < 12; i++)
             {
               if(getTopLevel(1) == i && isMgNum(getNum(1, i+1)) == False && 
                  isOrderActive(getNum(1, i)) == True && setPriceBuyStop() != 0 &&
                  getOrderPriceByNum(getMaxLongNum()) != setPriceBuyStop()) 
                 {
                   start = GetTickCount();                                  
                   ticket = OrderSend(Symbol(), OP_BUYSTOP, 
                                      getLotByLevel(getTopLevel(1) + 1),
                                      setPriceBuyStop(), 3, 0, 0,
                                      StringConcatenate(i + 1, " "), 
                                      getNum(1, i + 1), 0, Green);
                   if(ShowLog)
                     {
                       Print("   ", (GetTickCount() - start) / 1000,
                             " .");                         
                     }
                   if(ticket) 
                       PlaySound("alert.wav");
                   if(!ticket) 
                     {
                       err = GetLastError(); 
                       Print(" = ", err, " (", ErrorDescription(err), ")");
                     }                
                   return(1);
                 } 
             }
         } 
       //   
       if(getTopLevel(2) < maxLevel && !isMgNum(101))
         {    
           for(i = 1; i < 12; i++)
             {
               if(getTopLevel(2) == i && isMgNum(getNum(0, i + 1)) == False && 
                  isOrderActive(getNum(0, i)) == True && setPriceSellStop() != 0 && 
                  getOrderPriceByNum(getMaxShortNum()) != setPriceSellStop()) 
                 {
                   start = GetTickCount();                 
                   ticket = OrderSend(Symbol(), OP_SELLSTOP, 
                                      getLotByLevel(getTopLevel(2) + 1),
                                      setPriceSellStop(), 3, 0, 0,
                                      StringConcatenate(i + 1, " "),
                                      getNum(0, i + 1), 0, Red);                 
                   if(ShowLog)
                     {
                       Print("   ", (GetTickCount() - start) / 1000,
                             " .");                        
                     }
                   if(ticket) 
                       PlaySound("alert.wav");
                   if(!ticket) 
                     {
                       err = GetLastError(); 
                       Print(" = ", err, " (", ErrorDescription(err), ")");
                     }                
                   return(1);
                 } 
             }
         }
     }      
//  
   if(mode == 1)
     {
       //   
       if(getTopLevel(1) < maxLevel)
         {   
           for(i = 1; i < 12; i++)
             {
               if(getTopLevel(2) == i && isMgNum(getNum(0, i + 1)) == False && 
                  isOrderActive(getNum(0, i)) == True && setPriceBuyStop() != 0 && 
                  getOrderPriceByNum(getMaxShortNum())!= setPriceBuyStop()) 
                 {
                   //    - getTopLevel(1)
                   start = GetTickCount();
                   lot = getLotByLevel(getTopLevel(1) + 1);
                   if(lot > MarketInfo(Symbol(), MODE_MAXLOT)) 
                     {
                       lot = MarketInfo(Symbol(), MODE_MAXLOT);
                     }
                   ticket = OrderSend(Symbol(), OP_SELLLIMIT, lot, setPriceBuyStop(),
                                      3, 0, 0, StringConcatenate(i + 1, " "), 
                                      getNum(0,i+1),0,Green);
                   if(ShowLog)
                     {
                       Print("   ", (GetTickCount() - start) / 1000,
                             " .");                         
                     }
                   if(ticket) 
                       PlaySound("alert.wav");
                   if(!ticket) 
                     {
                       err = GetLastError(); 
                       Print(" = ", err, " (", ErrorDescription(err), ")");
                     }                
                   return(1);
                 } 
             }
         } 
       //   
       if(getTopLevel(2) < maxLevel)
         {    
           for(i = 1; i < 12; i++)
             {
               if(getTopLevel(1) == i && isMgNum(getNum(1, i + 1)) == False && 
                  isOrderActive(getNum(1, i)) == True && setPriceSellStop() != 0 && 
                  getOrderPriceByNum(getMaxLongNum()) != setPriceSellStop()) 
                 {
                   start = GetTickCount();                 
                   //     - getTopLevel(2)
                   lot = getLotByLevel(getTopLevel(2) + 1);
                   if(lot > MarketInfo(Symbol(), MODE_MAXLOT)) 
                     {
                       lot = MarketInfo(Symbol(), MODE_MAXLOT);
                     }
                   ticket = OrderSend(Symbol(), OP_BUYLIMIT, lot, setPriceSellStop(), 
                                      3, 0, 0, StringConcatenate(i + 1, " "), 
                                      getNum(1, i + 1), 0, Red);                
                   if(ShowLog)
                     {
                       Print("   ", (GetTickCount() - start) / 1000, 
                             " .");                        
                     }
                   if(ticket) 
                       PlaySound("alert.wav");
                   if(!ticket) 
                     {
                       err = GetLastError(); 
                       Print(" = ", err, " (", ErrorDescription(err), ")");
                     }                
                   return(1);
                 } 
             }
         }
     }      
  }     
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void setTrailingStop(int trailingSL, double multiplier)
  {
   int cnt1, t, s;
   double PriceSL,spread, temp;         
   t = OrdersTotal();
   s = MarketInfo(Symbol(), MODE_SPREAD);
   spread = s*Point;     
   if((AccountEquity() - AccountBalance()) > AccountBalance()*ProfitPercent*multiplier / 100)
     {           
       if(getBuyLotsSum(1) > getSellLotsSum(1))
         {  
           PriceSL = Bid - Point*trailingSL;
           if(mode_work == 0)
             {
               temp = Bid - getOrderPriceByNum(getMaxLongNum());
             }
           else 
             {
               temp = Bid - getOrderPriceByNum(getMaxShortNum());
             }
           if(temp > Point*trailingSL)
             {
               if(OrderStopLoss() < PriceSL && mode_work == 0)
                 { 
                   for(cnt1 = 0; cnt1 < t; cnt1++)
                     {
                       OrderSelect(cnt1, SELECT_BY_POS);
                       if(OrderType() == OP_BUY)
                         {
                           if(PriceSL > Bid)
                             {
                               OrderModify(OrderTicket(), OrderOpenPrice(), 
                                           OrderStopLoss(), PriceSL, 0, Green);
                             }
                           else 
                             {
                               OrderModify(OrderTicket(), OrderOpenPrice(), 
                                           PriceSL, OrderTakeProfit(), 0, Green);
                             }
                         }
                       if(OrderType() == OP_SELL)
                         {
                           if(PriceSL > Bid)
                             {
                               OrderModify(OrderTicket(), OrderOpenPrice(), 
                                           PriceSL + spread, OrderTakeProfit(),
                                           0, Green);
                             }                                
                           else 
                             {
                               OrderModify(OrderTicket(), OrderOpenPrice(), 
                                           OrderStopLoss(), PriceSL + spread, 0, Green);
                             }
                         }
                     }                       
                 }
               if(OrderStopLoss() > PriceSL && mode_work == 1 || OrderStopLoss() == 0)
                 {  
                   for(cnt1 = 0; cnt1 < t; cnt1++)
                     {
                       OrderSelect(cnt1, SELECT_BY_POS);
                       if(OrderType() == OP_BUY)
                         {
                           if(PriceSL > Bid)
                             {
                               OrderModify(OrderTicket(), OrderOpenPrice(), 
                                           OrderStopLoss(), PriceSL, 0, Green);
                             }
                           else 
                             {
                               OrderModify(OrderTicket(), OrderOpenPrice(), PriceSL, 
                                           OrderTakeProfit(), 0, Green);
                             }
                         }
                       if(OrderType() == OP_SELL)
                         {
                           if(PriceSL > Bid)
                             {
                               OrderModify(OrderTicket(), OrderOpenPrice(), 
                               PriceSL + spread, OrderTakeProfit(), 0, Green);
                             }
                           else 
                             {
                               OrderModify(OrderTicket(), OrderOpenPrice(), 
                                           OrderStopLoss(), PriceSL + spread, 0, Green);
                             }
                         }
                     }                       
                 }                          
             }                    
         }    
       if(getBuyLotsSum(1) < getSellLotsSum(1))
         {                               
           PriceSL = Ask + Point*trailingSL;
           if(mode_work == 0)
             {
               temp = getOrderPriceByNum(getMaxShortNum()) - Ask;
             }
           else
             {
               temp = getOrderPriceByNum(getMaxLongNum()) - Ask;
             }
           if(temp > Point*trailingSL)
             {                     
               if(OrderStopLoss() > PriceSL || OrderStopLoss() == 0 && mode_work == 0)
                 { 
                   for(cnt1 = 0; cnt1 < t; cnt1++)
                     {
                       OrderSelect(cnt1, SELECT_BY_POS);
                       if(OrderType() == OP_BUY)
                         {
                           if(PriceSL > Ask)
                             {
                               OrderModify(OrderTicket(), OrderOpenPrice(), 
                                           OrderStopLoss(), PriceSL-spread, 0, Green);
                             }
                           else 
                             {
                               OrderModify(OrderTicket(), OrderOpenPrice(), 
                                           PriceSL - spread, OrderTakeProfit(), 0, Green);
                             }
                         }
                       if(OrderType() == OP_SELL)
                         {
                           if(PriceSL > Ask)
                             {
                               OrderModify(OrderTicket(), OrderOpenPrice(), PriceSL,
                                           OrderTakeProfit(), 0, Green);
                             }
                           else 
                             {
                               OrderModify(OrderTicket(), OrderOpenPrice(), 
                                           OrderStopLoss(), PriceSL, 0, Green);
                             }
                         }
                     }                                                
                 }
               if(OrderStopLoss() < PriceSL && mode_work == 1)
                 { 
                   for(cnt1 = 0; cnt1 < t; cnt1++)
                     {
                       OrderSelect(cnt1, SELECT_BY_POS);
                       if(OrderType() == OP_BUY)
                         {
                           if(PriceSL > Ask)
                             {
                               OrderModify(OrderTicket(), OrderOpenPrice(), 
                                           OrderStopLoss(), PriceSL - spread, 0, Green);
                             }
                           else 
                             {
                               OrderModify(OrderTicket(), OrderOpenPrice(), 
                                           PriceSL - spread, OrderTakeProfit(), 0, Green);
                             }
                         }
                       if(OrderType() == OP_SELL)
                         {
                           if(PriceSL > Ask)
                             {
                               OrderModify(OrderTicket(), OrderOpenPrice(), PriceSL,
                                           OrderTakeProfit(), 0, Green);
                             }
                           else 
                             {
                               OrderModify(OrderTicket(), OrderOpenPrice(), 
                                           OrderStopLoss(), PriceSL, 0, Green);
                             }
                         }
                     }                                                
                 }
             }                     
         }  
     
     }    
  }
//+------------------------------------------------------------------+
//|  Breakdowning martingail  v 1.0.2                               |
//+------------------------------------------------------------------+
int start()
  {
   double s, spread, Risk, level, LotsDifferent, lot_buy, lot_sell, 
          multiplier, forstep;
   int total, err, i, start, cnt1;   
   string level_str, mode;
   bool ticket; 
   s = MarketInfo(Symbol(), MODE_SPREAD);
   spread = s*Point;   
   total = OrdersTotal();
   LotsDifferent = MathAbs(getBuyLotsSum(1) - getSellLotsSum(1));     
   if(MinMaxStepMode == 0)
     {
       Step = Step;
     }
   if(MinMaxStepMode == 1)
     {
       Step = MathCeil((AccountBalance() - AccountEquity() + 1)*100000 / AccountBalance());
       if(Step < 15)
         {
           Step = 15;
         }
       if(Step > 40)
         {
           Step = 40;
         }
     }
   if(MinMaxStepMode == 2)
     {      
       forstep = MathPow(AccountBalance() / AccountEquity(), 4);
       Step = MathCeil(forstep*15);
     }
   if(AccountEquity() / AccountBalance() < 0.7)
     {
       mode_work = 1;
     }
   else
     {
       mode_work = 0;
     }
//   ( )        
   if(MoneyManagement == true && LogariphmicMM == true)
     {              
       Risk = MathCeil(Riskfactor*100 / MathSqrt(AccountBalance()));
       if(Risk > 20) 
           Risk = 20;             
       startLots = MathCeil(AccountBalance()*Risk / 10000) / 10;               
       if(startLots > MarketInfo(Symbol(), MODE_MAXLOT)) 
         {
           startLots = MarketInfo(Symbol(), MODE_MAXLOT);
         }
       if(startLots < MarketInfo(Symbol(), MODE_MINLOT)) 
         {
           startLots = MarketInfo(Symbol(), MODE_MINLOT);
         }
     }
   if(MoneyManagement == true && LogariphmicMM == false)
     {
       startLots = NormalizeDouble(AccountBalance()*Riskfactor / 100000, 1);
       if(startLots > MarketInfo(Symbol(), MODE_MAXLOT)) 
         {
           startLots = MarketInfo(Symbol(), MODE_MAXLOT);
         }
       if(startLots < MarketInfo(Symbol(), MODE_MINLOT)) 
         {
           startLots = MarketInfo(Symbol(), MODE_MINLOT);
         }
     }     
   if(MoneyManagement == false && LogariphmicMM == false)    
     {
       startLots  =startLots;
     }
//,    OptimalTakePrifit            
   if(OptimalTakeProfit) 
     {
       multiplier = MathSqrt(LotsDifferent);
     }
   if(!OptimalTakeProfit) 
     {
       multiplier = 1;
     }         
//,    NoTradeBeforeNewDay
   if(getDayProfit(1, 0) > 0 && NoTradeBeforeNewDay)
     {
       TradeAllowed = false;
     }
   if(getDayProfit(1, 0) == 0 && NoTradeBeforeNewDay)
     {
       TradeAllowed = true;
     }
//           
   if(getBuyLotsSum(1) > getSellLotsSum(1))   
     {
       level = getOptimalTakeProfit(multiplier, false) - spread;
     }
   if(getBuyLotsSum(1) < getSellLotsSum(1))   
     {
       level = getOptimalTakeProfit(multiplier, true) + spread;
     }
   if(level != 0)
     {
       level_str = DoubleToStr(level, Digits);
     }
   else 
     {
       //    
       level_str="  , ...";
     }
   if(mode_work == 0)
     {
       mode = " ( BuyStop  SellStop)";
     }
   if(mode_work == 1)
     {
       mode = "  ( BuyLimit  SellLimit)";
     }
   ObjectSetText("label_object1", StringConcatenate("     ",
                 Symbol(), ": ", level_str), 9, "Lucida Console", NavajoWhite);
   ObjectSetText("label_object2", StringConcatenate("  : ", mode), 9, 
                 "Lucida Console", NavajoWhite);
   Comment("\n", "\n", "\n",
           "        = ", NormalizeDouble(getAllProfit(2), 2), " $", "\n",
           "       = ", NormalizeDouble(getAllProfit(3), 2), " $", "\n",
           "    ---------------------------------------------------", "\n",
           "          = ", NormalizeDouble(getDayProfit(1, 0), 2), " $", "\n",
           "            = ", NormalizeDouble(getDayProfit(1, 1), 2), " $", "\n",
           "      = ", NormalizeDouble(getDayProfit(1, 2), 2), " $", "\n",
           "    ---------------------------------------------------", "\n",
           "    Balance       = ",NormalizeDouble(AccountBalance(),2), " $", "\n",
           "    Equity         = ",NormalizeDouble(AccountEquity(),2), " $", "\n",
           "    Free Margin = ", NormalizeDouble(AccountFreeMargin(),2), " $", "\n",
           "    ---------------------------------------------------", "\n",
           "    Sell Lots = ", getSellLotsSum(1), "   |   Buy Lots = ", getBuyLotsSum(1), "\n",
           "    ---------------------------------------------------", "\n",
           "        1:", AccountLeverage());
//    ,     -          
   if(isMgNum(getNum(1, 1)) == False && isMgNum(getNum(1, 1)) == False && !TradeAllowed)
     {
       return;
     }
//   ,    
   if(isMgNum(getNum(1, 1)) == False && TradeAllowed) 
     {
       start = GetTickCount();
       ticket = OrderSend(Symbol(), OP_BUY, getLotByLevel(1), NormalizeDouble(Ask, Digits), 
                          3, 0, 0, " ", getNum(1, 1), 0, Green);
       if(ShowLog)
         {
           Print("     ", Symbol(), " ask= ", Ask, 
                 " ticket=", ticket);
           Print("   ", (GetTickCount() - start) / 1000, " .");  
         }                     
       if(ticket) 
           PlaySound("alert.wav");
       if(!ticket) 
         {
           err = GetLastError(); 
           Print(" = ", err, " (", ErrorDescription(err), ")");
         }                
     }
   if(isMgNum(getNum(0, 1)) == False && TradeAllowed) 
     {
       start = GetTickCount();
       ticket = OrderSend(Symbol(), OP_SELL, getLotByLevel(1), NormalizeDouble(Bid, Digits),
                          3, 0, 0, " ", getNum(0, 1), 0, Green);
       if(ShowLog)
         {
           Print("     ", Symbol(), " Bid= ", Bid, 
                 " ticket=", ticket);
           Print("   ", (GetTickCount() - start) / 1000, " .");  
         }
       if(ticket) 
           PlaySound("alert.wav");               
       if(!ticket) 
         {
           err = GetLastError(); 
           Print(" = ", err, " (", ErrorDescription(err), ")");
         }                
     }            
//  ,    
   setPendingOrders(mode_work);
//   BuyStop  SellStop (BuyLimit  SellLimit  mode_work = 1)
   if(mode_work == 0)
     {      
       if(getOrderPriceByNum(getNextOrderNum(getMaxShortNum())) < setPriceSellStop() && 
          setPriceSellStop() != 0)
         { 
           // 
           modOrder(getNextOrderNum(getMaxShortNum()), setPriceSellStop(), 0);
         }
       if(getOrderPriceByNum(getNextOrderNum(getMaxLongNum())) > setPriceBuyStop() && 
          setPriceBuyStop()!=0)
         { 
           // 
           modOrder(getNextOrderNum(getMaxLongNum()),setPriceBuyStop(),0); 
         }
     }
   if(mode_work == 1)
     {      
       if(getOrderPriceByNum(getNextOrderNum(getMaxLongNum())) < setPriceSellStop() && 
          setPriceSellStop() != 0)
         { 
           modOrder(getNextOrderNum(getMaxLongNum()), setPriceSellStop(), 0);
         }
       if(getOrderPriceByNum(getNextOrderNum(getMaxShortNum())) > setPriceBuyStop() && 
          setPriceBuyStop() != 0)
         { 
           modOrder(getNextOrderNum(getMaxShortNum()), setPriceBuyStop(), 0);
         }
     }
//    
   if(MathAbs(getBuyLotsSum(1) - getSellLotsSum(1)) < 0.2 && 
      (isOrderActive(getNum(0, 2)) || isOrderActive(getNum(1, 2))))
     {
       //         - 
       //    (  )
       getProfitOrdersClose();                              
     }
   if(getAllProfit(1) > AccountBalance()*ProfitPercent*multiplier / 100 && TrailingStop == 0)
     {
       //                                    
       getProfitOrdersClose();                              
     }           
   if(TrailingStop != 0)
     {
       //  ,    
       setTrailingStop(TrailingStop, multiplier);
     }
//      ,    , 
// ..      
//   ,                
   if(isOrderActive(getNum(1, 1)) == False)
     {
       for(i = getNum(1, 2); i < getNum(1, 9); i += 10)
         {
           //     
           deleteOrderNum(i);
         }          
     }           
   if(isOrderActive(getNum(0, 1)) == False)
     {
       // 
       for(i = getNum(0, 2); i < getNum(0, 9); i+=10)
         {
           deleteOrderNum(i);
         }          
     }
   return(0);
  }         
//+------------------------------------------------------------------+

