//---------------------------------------------------------------------------
// Ultimate oscillator
//---------------------------------------------------------------------------
library UltimateOscillator;

uses
  SysUtils, Math, graphics, IndicatorInterfaceUnit, TechnicalFunctions;

var
  // External variables
  Period1: integer;
  Period2: integer;
  Period3: integer;

  // Buffers
  buff: TIndexBuffer;

//---------------------------------------------------------------------------
// Initialize indicator
//---------------------------------------------------------------------------
procedure Init; stdcall;
begin
  // define properties
  IndicatorShortName('Ultimate Oscillator');
  SetOutputWindow(ow_SeparateWindow);
  IndicatorDigits(2);
  SetEmptyValue(50);
  AddLevel(30, psDot, 1, cl_GridColor);
  AddLevel(50, psDot, 1, cl_GridColor);
  AddLevel(70, psDot, 1, cl_GridColor);

  // register options
  AddSeparator('Common');

  RegOption('Period 1', ot_Integer, Period1);
  SetOptionRange('Period 1', 1, MaxInt);
  Period1 := 7;

  RegOption('Period 2', ot_Integer, Period2);
  SetOptionRange('Period 2', 1, MaxInt);
  Period2 := 14;

  RegOption('Period 3', ot_Integer, Period3);
  SetOptionRange('Period 3', 1, MaxInt);
  Period3 := 28;

  // create buffers
  buff := CreateIndexBuffer;

  IndicatorBuffers(1);
  SetIndexBuffer(0, buff);
  SetIndexStyle(0, ds_Line, psSolid, 2, clRed);
  SetIndexLabel(0, 'Ultimate Oscillator');
end;

//---------------------------------------------------------------------------
// Deinitialize indicator
//---------------------------------------------------------------------------
procedure Done; stdcall;
begin

end;

//---------------------------------------------------------------------------
// Calculate requested bar
//---------------------------------------------------------------------------
procedure Calculate(index: integer); stdcall;
var
  i: integer;
  c, h, l, a1, a2, a3, b1, b2, b3: double;
begin
  if index + period3 >= Bars then
    exit;

  a1 := 0;
  a2 := 0;
  a3 := 0;
  b1 := 0;
  b2 := 0;
  b3 := 0;

  for i:=0 to max(max(Period1, Period2), Period3) - 1 do
    begin
      c := close(index + i);
      h := high(index + i);
      l := low(index + i);

      if i < Period1 then
        begin
          a1 := a1 + (c - l);
          b1 := b1 + (h - l);
        end;

      if i < Period2 then
        begin
          a2 := a2 + (c - l);
          b2 := b2 + (h - l);
        end;

      if i < Period3 then
        begin
          a3 := a3 + (c - l);
          b3 := b3 + (h - l);
        end;
    end;

  try
    buff[index] := (a1/b1*4 + a2/b2*2 + a3/b3)/7*100;
  except
    buff[index] := 50;
  end;
end;

exports

  Init, Done, Calculate;

end.
