//---------------------------------------------------------------------------
// Rate Of Change (ROC) indicator
//---------------------------------------------------------------------------
library ROC;

uses
  graphics,
  windows,
  IndicatorInterfaceUnit,
  TechnicalFunctions in 'TechnicalFunctions.pas';

var
  // External variables
  period: integer;
  ApplyToPrice: integer;

  // Buffers
  buff: TIndexBuffer;


//---------------------------------------------------------------------------
// Initialize indicator
//---------------------------------------------------------------------------
procedure Init; stdcall;
begin
  // define properties
  IndicatorShortName('Rate Of Change (ROC)');
  SetOutputWindow(ow_SeparateWindow);
  SetEmptyValue(0.12345);
  AddLevel(0, psDot, 1, cl_GridColor);

  // register options
  AddSeparator('Common');

  RegOption('Period', ot_Integer, period);
  SetOptionRange('Period', 1, MaxInt);
  period := 14;

  RegApplyToPriceOption(ApplyToPrice);

  // create buffers
  buff := CreateIndexBuffer;

  IndicatorBuffers(1);
  SetIndexBuffer(0, buff);
  SetIndexStyle(0, ds_Line, psSolid, 1, RGB($1E, $90, $FF));
  SetIndexLabel(0, 'ROC');
end;

//---------------------------------------------------------------------------
// Deinitialize indicator
//---------------------------------------------------------------------------
procedure Done; stdcall;
begin

end;

//---------------------------------------------------------------------------
// Calculate requested bar
//---------------------------------------------------------------------------
procedure Calculate(index: integer); stdcall;
begin
  if index + period >= Bars then exit;

  try
    buff[index] := ((GetPrice(index, TPriceType(ApplyToPrice)) -
      GetPrice(index + period, TPriceType(ApplyToPrice)))/
      GetPrice(index + period, TPriceType(ApplyToPrice)))*100;
  except
    buff[index] := 0.12345;
  end;
end;

exports

Init, Done, Calculate;

end.
