//---------------------------------------------------------------------------
// Daily Range of Price Indicator
// Written by Oleg Polovinkin
// Version 0.5
//---------------------------------------------------------------------------
library PriceDailyRange;

uses
  sysutils, graphics, IndicatorInterfaceUnit;

var
  // External variables
  TimeShiftParam: integer;
  DeltaParam: integer;
  ApplyToPrice: integer;

  TimeShift: TDateTime;

  // Buffers
  DailyPriceHiBuf: TIndexBuffer;
  DailyPriceLoBuf: TIndexBuffer;


//---------------------------------------------------------------------------
// Initialize indicator
//---------------------------------------------------------------------------
procedure Init; stdcall;
begin
  // define properties
  IndicatorShortName('Price Daily Range');
  SetOutputWindow(ow_ChartWindow);

  RegOption('Delta points', ot_Integer, DeltaParam);
  DeltaParam := 0;

  RegOption('Start of day shift (hours)', ot_Integer, TimeShiftParam);
  TimeShiftParam := 0;

  RegOption('Apply to price', ot_EnumType, ApplyToPrice);
  AddOptionValue('Apply to price', 'Open/Close');
  AddOptionValue('Apply to price', 'High/Low');
  ApplyToPrice := 0;

  // Convert Time Shift;

  // create buffers
  IndicatorBuffers(2);
  DailyPriceHiBuf := CreateIndexBuffer;
  DailyPriceLoBuf := CreateIndexBuffer;
  SetIndexBuffer(0, DailyPriceHiBuf);
  SetIndexBuffer(1, DailyPriceLoBuf);
  SetIndexStyle(0, ds_Line, psSolid, 1, clBlue);
  SetIndexLabel(0, 'Up Band');
  SetIndexStyle(1, ds_Line, psSolid, 1, clRed);
  SetIndexLabel(1, 'Down Band');
end;

//---------------------------------------------------------------------------
// Deinitialize indicator
//---------------------------------------------------------------------------
procedure Done; stdcall;
begin

end;

//---------------------------------------------------------------------------
// Calculate requested bar
//---------------------------------------------------------------------------
procedure Calculate(index: integer); stdcall;
var
	i: integer;
  NewHi, NewLo: double;
  NowDate: double;
  IsChangedHi, IsChangedLo: boolean;

	//////////////////////////////////////////////////
	function GetPriceHi(index: integer): double;
  var
  	CurOpen, CurClose : double;
	begin
		case ApplyToPrice of
			0:	begin
      			CurOpen := Open(index);
	      		CurClose := Close(index);
  	    		if (CurOpen > CurClose) then
    	      	result := CurOpen + (DeltaParam * Point)
      	    else
        	  	result := CurClose + (DeltaParam * Point);
      		end;
			1:   result := High(index) + (DeltaParam * Point);
			else
      	result := 0;
		end;
	end;

	//////////////////////////////////////////////////
	function GetPriceLo(index: integer): double;
  var
  	CurOpen, CurClose : double;
	begin
		case ApplyToPrice of
			0:	begin
						CurOpen := Open(index);
						CurClose := Close(index);
						if (CurOpen < CurClose) then
							result := CurOpen - (DeltaParam * Point)
						else
							result := CurClose - (DeltaParam * Point);
      		end;
			1:	result := Low(index) - (DeltaParam * Point);
			else
      	result := 0;
		end;
	end;

	//////////////////////////////////////////////////
	function ShiftedDate(index: integer; shift: double): double;
  var
  	CorrectDate : double;
	begin
    CorrectDate := Time(index) + shift;

    if ( shift < 0 ) then begin
      if (DayOfWeek( CorrectDate ) = 1) then begin
        CorrectDate := CorrectDate - 2;
      end else if (DayOfWeek( CorrectDate ) = 7) then begin
        CorrectDate := CorrectDate - 1;
      end;
    end else begin
      if (DayOfWeek( CorrectDate ) = 1) then CorrectDate := CorrectDate + 1
      else if (DayOfWeek( CorrectDate ) = 7) then CorrectDate := CorrectDate + 2;
    end;

    ShiftedDate := CorrectDate;
	end;


//////////////////////////////////////////////////
begin
//  Print( 'PDR: Calculate started, index = ' + IntToStr( index ) + ' of Bars = ' + IntToStr(Bars) );

  // Translate  TimeShift to TDateTime format
  TimeShift := EncodeTime( abs(TimeShiftParam), 0, 0, 0 );
  if ( TimeShiftParam > 0 ) then TimeShift := -TimeShift;

  // Don't count current bar
  index := index + 1;

	if (index >= Bars) or (index < 0) then begin
		DailyPriceLoBuf[index] := 0;
		DailyPriceHiBuf[index] := 0;

	end else if ( DailyPriceLoBuf[index] = 0 ) then begin
		IsChangedHi := False;
		IsChangedLo := False;
		NewHi := GetPriceHi(index);
		NewLo := GetPriceLo(index);
		NowDate := Int(ShiftedDate(index, TimeShift));

		// Calculate Highest and Lowest prices of this day
		i := index + 1;
    if (NowDate = Int(ShiftedDate(i, TimeShift))) and (i < Bars) then begin

			if (DailyPriceHiBuf[i] < NewHi) then begin
        IsChangedHi := True;
      end;

			if (DailyPriceLoBuf[i] > NewLo) then begin
        IsChangedLo := True;
      end;


  		// Assign HI if necessary
  		i := index;

      if ( IsChangedHi = True ) or ( IsChangedLo = True ) then begin
        while (NowDate = Int(ShiftedDate(i, TimeShift))) and (i < Bars) do begin
          if ( IsChangedHi = True ) then DailyPriceHiBuf[i] := NewHi;
          if ( IsChangedLo = True ) then DailyPriceLoBuf[i] := NewLo;
          i := i + 1;
        end;
  		end;

      DailyPriceHiBuf[index] := DailyPriceHiBuf[index+1];
      DailyPriceLoBuf[index] := DailyPriceLoBuf[index+1];

    // If this is the first bar for the day
    end else begin
      DailyPriceHiBuf[index] := NewHi;
      DailyPriceLoBuf[index] := NewLo;
    end;

	end;
end;

exports

Init, Done, Calculate;

end.




