//---------------------------------------------------------------------------
// Pivot Points
//---------------------------------------------------------------------------
library PivotPoints;

uses
  SysUtils, classes, graphics, math,
  IndicatorInterfaceUnit,
  TechnicalFunctions in 'TechnicalFunctions.pas';

var
  Continuous: boolean;
  ShowMidpoints: boolean;

  // index buffers
  PP, R1, R2, R3, S1, S2, S3, M1, M2, M3, M4: TIndexBuffer;


//---------------------------------------------------------------------------
// Initialization
//---------------------------------------------------------------------------
procedure Init; stdcall;
begin
  // define parameters
  IndicatorShortName('Pivot Points');
  SetOutputWindow(ow_ChartWindow);

  RegOption('Continuous', ot_Boolean, Continuous);
  Continuous := false;

  RegOption('ShowMidpoints', ot_Boolean, ShowMidpoints);
  ShowMidpoints := false;

  // create index buffers
  PP := CreateIndexBuffer;
  R1 := CreateIndexBuffer;
  R2 := CreateIndexBuffer;
  R3 := CreateIndexBuffer;
  S1 := CreateIndexBuffer;
  S2 := CreateIndexBuffer;
  S3 := CreateIndexBuffer;
  M1 := CreateIndexBuffer;
  M2 := CreateIndexBuffer;
  M3 := CreateIndexBuffer;
  M4 := CreateIndexBuffer;

  IndicatorBuffers(11);

  SetIndexBuffer(0, R3);
  SetIndexStyle(0, ds_Line, psSolid, 1, clGreen);
  SetIndexLabel(0, 'R3');

  SetIndexBuffer(1, R2);
  SetIndexStyle(1, ds_Line, psDashDot, 1, clBlue);
  SetIndexLabel(1, 'R2');

  SetIndexBuffer(2, R1);
  SetIndexStyle(2, ds_Line, psDot, 1, clRed);
  SetIndexLabel(2, 'R1');

  SetIndexBuffer(3, PP);
  SetIndexStyle(3, ds_Line, psDot, 1, clMaroon);
  SetIndexLabel(3, 'PP');

  SetIndexBuffer(4, S1);
  SetIndexStyle(4, ds_Line, psDot, 1, clRed);
  SetIndexLabel(4, 'S1');

  SetIndexBuffer(5, S2);
  SetIndexStyle(5, ds_Line, psDashDot, 1, clBlue);
  SetIndexLabel(5, 'S2');

  SetIndexBuffer(6, S3);
  SetIndexStyle(6, ds_Line, psSolid, 1, clGreen);
  SetIndexLabel(6, 'S3');

  SetIndexBuffer(7, M1);
  SetIndexStyle(7, ds_Line, psDot, 1, clGray);
  SetIndexLabel(7, 'M1');

  SetIndexBuffer(8, M2);
  SetIndexStyle(8, ds_Line, psDot, 1, clGray);
  SetIndexLabel(8, 'M2');

  SetIndexBuffer(9, M3);
  SetIndexStyle(9, ds_Line, psDot, 1, clGray);
  SetIndexLabel(9, 'M3');

  SetIndexBuffer(10, M4);
  SetIndexStyle(10, ds_Line, psDot, 1, clGray);
  SetIndexLabel(10, 'M4');
end;

//---------------------------------------------------------------------------
// Deinitialization
//---------------------------------------------------------------------------
procedure Done; stdcall;
begin
  //
end;

//---------------------------------------------------------------------------
// Calculate bar
//---------------------------------------------------------------------------
procedure Calculate(index: integer); stdcall;
var
  day, i: integer;
  h, l, c, _pp, _R1, _S1, _R2, _S2: double;
begin
  if TimeFrame > PERIOD_H4 then
    exit;

  day := trunc(Time(index));
  if trunc(Time(Bars - 1)) >= day then
    exit;

  if trunc(Time(index + 1)) = day then
    begin
      PP[index] := PP[index + 1];
      R1[index] := R1[index + 1];
      R2[index] := R2[index + 1];
      R3[index] := R3[index + 1];
      S1[index] := S1[index + 1];
      S2[index] := S2[index + 1];
      S3[index] := S3[index + 1];
      M1[index] := M1[index + 1];
      M2[index] := M2[index + 1];
      M3[index] := M3[index + 1];
      M4[index] := M4[index + 1];
      exit;
    end;

  if not(Continuous) then
    begin
      PP[index + 1] := 0;
      R1[index + 1] := 0;
      R2[index + 1] := 0;
      R3[index + 1] := 0;
      S1[index + 1] := 0;
      S2[index + 1] := 0;
      S3[index + 1] := 0;
      M1[index + 1] := 0;
      M2[index + 1] := 0;
      M3[index + 1] := 0;
      M4[index + 1] := 0;
    end;

  i := index + 1;
  day := trunc(Time(i));

  h := High(i);
  l := Low(i);
  c := Close(i);
  inc(i);

  while (trunc(Time(i)) = day) and (i < Bars) do
    begin
      h := Max(High(i), h);
      l := Min(Low(i), l);
      inc(i);
    end;

  _pp := (h + l + c)/3;
  _R1 := 2*_pp - l;
  _S1 := 2*_pp - h;
  _R2 := _pp + (_R1 - _S1);
  _S2 := _pp - (_R1 - _S1);
  PP[index] := _pp;
  R1[index] := _R1;
  R2[index] := _R2;
  R3[index] := h + 2*(_pp - l);
  S1[index] := _S1;
  S2[index] := _S2;
  S3[index] := l - 2*(h - _pp);

  if ShowMidpoints then
    begin
      M1[index] := (_S1 + _S2)/2;
      M2[index] := (_S1 + _pp)/2;
      M3[index] := (_R1 + _pp)/2;
      M4[index] := (_R1 + _R2)/2;
    end;
end;

exports

Init, Done, Calculate;

end.


