library Parabolic;

uses
  SysUtils, Classes, graphics, IndicatorInterfaceUnit;

var
  increment: double;
  max_value: double;

  SAR: TIndexBuffer;

//---------------------------------------------------------------------------
// Initialize
//---------------------------------------------------------------------------
procedure Init; stdcall;
begin
  // Define parameters
  IndicatorShortName('Parabolic');
  SetOutputWindow(ow_ChartWindow);

  // register external parameters
  AddSeparator('Common');
  RegOption('Increment', ot_Double, increment);
  SetOptionRange('Increment', 0.01, 1);
  increment := 0.02;

  RegOption('Max Value', ot_Double, max_value);
  SetOptionRange('Max Value', 0.1, 100);
  max_value := 0.2;

  // Create index buffer
  IndicatorBuffers(1);
  SAR := CreateIndexBuffer;
  SetIndexBuffer(0, SAR);
  SetIndexStyle(0, ds_Symbol, psSolid, 1, clBlue);
  SetIndexSymbol(0, 159, 0, 0);
end;

//---------------------------------------------------------------------------
// Deinitialization procedure
//---------------------------------------------------------------------------
procedure Done; stdcall;
begin
  // do nothing
end;

//---------------------------------------------------------------------------
// Calculate single bar
//---------------------------------------------------------------------------
procedure Calculate(index: integer); stdcall;
var
  i: integer;
  condition1, condition2: boolean;
  incr: double;

  function Highest(period: integer): double;
  var
    k: integer;
    max: double;
  begin
    max:=0;
    for k:=index to index+period-1 do
      if High(k)>max then max:=High(k);
    result:=max;
  end;

  function Lowest(period: integer): double;
  var
    k: integer;
    min: double;
  begin
    min:=25000;
    for k:=index to index+period-1 do
      if Low(k)<min then min:=Low(k);
    result:=min;
  end;

begin
  if

  if index = Bars - 1 then
    begin
      if High(Bars - 1) > Low(Bars - 1) then
        SAR[index] := Low(index);
      else
        SAR[index] := High(index);
      exit;
    end;

  if condition1 := (High(index+1) > SAR[index+2]);
  if condition2 := (Low(index+1) < SAR[index+2]);
  incr := increment;

  if ((High(index) > SAR[index+1]) and (High(index+1) < SAR[index+2])) then
    begin
      i:=1;
      while (High(index + i) < SAR[index + i + 1]) do
        begin
          inc(i);
          if i > 10 then break;
        end;
      SAR[index] := Lowest(i + 1);
      exit;
    end;

  if ((Low(index) < SAR[index+1]) and (Low(index+1) > SAR[index+2])) then
  begin
    i:=1;
    while (Low(index+i) > SAR[index+i+1]) do
    begin
      i:=i+1;
      if i>10 then break;
    end;
    SAR[index]:= Highest(i+1);
    exit;
  end;

  if condition1 then
    for i:= 1 to 150 do begin
      if (Low(index+i)<SAR[index+i+1]) then break;
      incr :=incr*2;
    end
  else if condition2 then
    for i:= 1 to 150 do begin
      if (High(index+i)>SAR[index+i+1]) then begin break; end;
      incr := incr*2;
    end;
     if incr>max_value then incr:=max_value;
     if condition1 then
     begin
       SAR[index]:= incr * (High (index + 1) - SAR [index + 1]) + SAR [index + 1];
     end;
     if condition2 then
     begin
       SAR[index]:= incr * (Low (index + 1) - SAR [index + 1]) + SAR [index + 1];
     end;
end;

exports

Init, Done, Calculate;

end.
