//---------------------------------------------------------------------------
// Momentum indicator
//---------------------------------------------------------------------------
library Momentum;

uses
  graphics, windows,
  IndicatorInterfaceUnit,
  TechnicalFunctions in 'TechnicalFunctions.pas';

var
  // External variables
  period: integer;
  ApplyToPrice: integer;

  // Buffers
  buff: TIndexBuffer;


//---------------------------------------------------------------------------
// Initialize indicator
//---------------------------------------------------------------------------
procedure Init; stdcall;
begin
  // define properties
  IndicatorShortName('Momentum');
  SetOutputWindow(ow_SeparateWindow);
  SetEmptyValue(99.99);

  // register options
  AddSeparator('Common');

  RegOption('Period', ot_Integer, period);
  SetOptionRange('Period', 1, MaxInt);
  period := 14;

  RegApplyToPriceOption(ApplyToPrice);

  // create buffers
  buff := CreateIndexBuffer;

  IndicatorBuffers(1);
  SetIndexBuffer(0, buff);
  SetIndexStyle(0, ds_Line, psSolid, 1, RGB($1E, $90, $FF));
  SetIndexLabel(0, 'Momentum');
end;

//---------------------------------------------------------------------------
// Deinitialize indicator
//---------------------------------------------------------------------------
procedure Done; stdcall;
begin

end;

//---------------------------------------------------------------------------
// Calculate requested bar
//---------------------------------------------------------------------------
procedure Calculate(index: integer); stdcall;
begin
  if Index + period >= Bars then exit;

  try
    buff[index] := GetPrice(index, TPriceType(ApplyToPrice))*100/
      GetPrice(index + period, TPriceType(ApplyToPrice));
  except
    buff[index] := 99.99;
  end;
end;

exports

Init, Done, Calculate;

end.
