//---------------------------------------------------------------------------
// MA_Crossover_Signal
//---------------------------------------------------------------------------
library MA_Crossover_Signal;

uses
  graphics,
  IndicatorInterfaceUnit,
  TechnicalFunctions,
  SysUtils;

var
  // External variables
  FasterMode: integer;
  FasterMA: integer;
  SlowerMode: integer;
  SlowerMA: integer;

  // Buffers
  UpBuffer: TIndexBuffer;
  DwBuffer: TIndexBuffer;
  fastMA: TIndexBuffer;
  slowMA: TIndexBuffer;

//---------------------------------------------------------------------------
// Initialize indicator
//---------------------------------------------------------------------------
procedure Init; stdcall;
begin
  // define properties
  IndicatorShortName('MA Crossover Signals');
  SetOutputWindow(ow_ChartWindow);

  // register options
  AddSeparator('Common');

  RegMATypeOption(FasterMode, 'Mode for fast MA');

  RegOption('Fast Period', ot_Integer, FasterMA);
  SetOptionRange('Fast Period', 1, MaxInt);
  FasterMA:= 5;

  RegMATypeOption(SlowerMode, 'Mode for slow MA');

  RegOption('Slow Period', ot_Integer, SlowerMA);
  SetOptionRange('Slow Period', 1, MaxInt);
  SlowerMA:= 7;

  // create buffers
  IndicatorBuffers(2);
  UpBuffer:= CreateIndexBuffer;
  DwBuffer:= CreateIndexBuffer;
  fastMA:= CreateIndexBuffer;
  slowMA:= CreateIndexBuffer;

  SetIndexBuffer(0, UpBuffer);
  SetIndexStyle(0, ds_Symbol, psSolid, 1, clGreen);
  SetIndexSymbol(0, 233, 0, 0);

  SetIndexBuffer(1, DwBuffer);
  SetIndexStyle(1, ds_Symbol, psSolid, 1, clRed);
  SetIndexSymbol(1, 234, 0, 0);
end;

//---------------------------------------------------------------------------
// Deinitialize indicator
//---------------------------------------------------------------------------
procedure Done; stdcall;
begin

end;

//---------------------------------------------------------------------------
// Calculate requested bar
//---------------------------------------------------------------------------
procedure Calculate(index: integer); stdcall;
var
   Range, AvgRange: double;
   SSP, i1: integer;

begin

  SSP:= 9;
	AvgRange:= 0;

	for i1:= index to (index + SSP) do AvgRange:= AvgRange + Abs(High(i1) - Low(i1));
	Range:= AvgRange / (SSP + 1);

  fastMA[index]:= GetMA(index, 0, FasterMA, TMAType(FasterMode), pt_Close, fastMA[index+1]);
  slowMA[index]:= GetMA(index, 0, SlowerMA, TMAType(SlowerMode), pt_Close, slowMA[index+1]);

  if ((fastMA[index] > slowMA[index]) and (fastMA[index + 1] < slowMA[index + 1])) then // and (fastMA[index - 1] < slowMA[index - 1])
    UpBuffer[index]:= Low(index) - Range * 0.5
  else
    UpBuffer[index] := 0;

  if ((fastMA[index] < slowMA[index]) and (fastMA[index + 1] > slowMA[index + 1])) then // and (fastMA[index - 1] > slowMA[index - 1])
    DwBuffer[index]:= High(index) + Range * 0.5
  else
    DwBuffer[index] := 0;
end;

exports

Init, Done, Calculate;

end.
