library LSMA;

uses
  graphics, IndicatorInterfaceUnit;

var
  // external parameters
  period: integer;          // ?? period
  // index buffer
  MA: TIndexBuffer;

//---------------------------------------------------------------------------
// Initialization procedure
//---------------------------------------------------------------------------

procedure Init; stdcall;

begin
  // Define parameters
  IndicatorShortName('LSMA');
  SetOutputWindow(ow_ChartWindow);

  // register external parameters
  AddSeparator('Common');
  RegOption('Period', ot_Integer, period);
  SetOptionRange('Period', 1, MaxInt);
  period := 20;

  // Create index buffer
  IndicatorBuffers(1);
  MA := CreateIndexBuffer;
  SetIndexBuffer(0, MA);
  SetIndexStyle(0, ds_Line, psSolid, 1, clBlue);
end;

//---------------------------------------------------------------------------
// Deinitialization procedure
//---------------------------------------------------------------------------
procedure Done; stdcall;
begin
  // do nothing
end;

//---------------------------------------------------------------------------
// Calculate single bar
//---------------------------------------------------------------------------
procedure Calculate(index: integer); stdcall;
var
  i: integer;
  sum: double;
begin
  sum := 0;
  for i := 0 to period - 1 do
    begin
      sum := sum + (i - (period + 1) / 3) * Close(index + period - i);
    end;
  MA[index] := sum * 6 / (period * (period + 1));
end;

exports
Init, Done, Calculate;

end.
