library FTLM_STLMv2;

uses
  SysUtils,
  Classes,
  graphics,
  windows,
  IndicatorInterfaceUnit;

var
  // 
  STLMBuffer, FTLMBuffer: TIndexBuffer;

//-------------------------------------
// 
//-------------------------------------
procedure Init; stdcall;
begin
  //  
  IndicatorShortName('FTLM-STLM');
  SetOutputWindow(ow_SeparateWindow);
  Addlevel(0, psDot, 1, cl_GridColor); //  0
  SetEmptyValue(MaxInt);

  // 
  STLMBuffer := CreateIndexBuffer;
  FTLMBuffer := CreateIndexBuffer;

  IndicatorBuffers(2);
  SetIndexBuffer(0,STLMBuffer);
  SetIndexStyle(0, ds_Line, psSolid, 2, clYellow);
  SetIndexLabel(0, 'STLM');

  SetIndexBuffer(1,FTLMBuffer);
  SetIndexStyle(1, ds_Line, psSolid, 2, clAqua);
  SetIndexLabel(1, 'FTLM');
end;

//---------------------------------------------------------------------------
//  
//---------------------------------------------------------------------------
procedure Done; stdcall;
begin

end;

//---------------------------------------------------------------------------
// Calculate requested bar
//---------------------------------------------------------------------------
procedure Calculate(index: integer); stdcall;
var
   value1, value2, value3, value4: double;
begin
  value1 :=
    0.4360409450*Close(index+0)
    +0.3658689069*Close(index+1)
    +0.2460452079*Close(index+2)
    +0.1104506886*Close(index+3)
    -0.0054034585*Close(index+4)
    -0.0760367731*Close(index+5)
    -0.0933058722*Close(index+6)
    -0.0670110374*Close(index+7)
    -0.0190795053*Close(index+8)
    +0.0259609206*Close(index+9)
    +0.0502044896*Close(index+10)
    +0.0477818607*Close(index+11)
    +0.0249252327*Close(index+12)
    -0.0047706151*Close(index+13)
    -0.0272432537*Close(index+14)
    -0.0338917071*Close(index+15)
    -0.0244141482*Close(index+16)
    -0.0055774838*Close(index+17)
    +0.0128149838*Close(index+18)
    +0.0226522218*Close(index+19)
    +0.0208778257*Close(index+20)
    +0.0100299086*Close(index+21)
    -0.0036771622*Close(index+22)
    -0.0136744850*Close(index+23)
    -0.0160483392*Close(index+24)
    -0.0108597376*Close(index+25)
    -0.0016060704*Close(index+26)
    +0.0069480557*Close(index+27)
    +0.0110573605*Close(index+28)
    +0.0095711419*Close(index+29)
    +0.0040444064*Close(index+30)
    -0.0023824623*Close(index+31)
    -0.0067093714*Close(index+32)
    -0.0072003400*Close(index+33)
    -0.0047717710*Close(index+34)
    +0.0005541115*Close(index+35)
    +0.0007860160*Close(index+36)
    +0.0130129076*Close(index+37)
    +0.0040364019*Close(index+38);

    value2 :=
    -0.0025097319*Close(index+0)
    +0.0513007762*Close(index+1)
    +0.1142800493*Close(index+2)
    +0.1699342860*Close(index+3)
    +0.2025269304*Close(index+4)
    +0.2025269304*Close(index+5)
    +0.1699342860*Close(index+6)
    +0.1142800493*Close(index+7)
    +0.0513007762*Close(index+8)
    -0.0025097319*Close(index+9)
    -0.0353166244*Close(index+10)
    -0.0433375629*Close(index+11)
    -0.0311244617*Close(index+12)
    -0.0088618137*Close(index+13)
    +0.0120580088*Close(index+14)
    +0.0233183633*Close(index+15)
    +0.0221931304*Close(index+16)
    +0.0115769653*Close(index+17)
    -0.0022157966*Close(index+18)
    -0.0126536111*Close(index+19)
    -0.0157416029*Close(index+20)
    -0.0113395830*Close(index+21)
    -0.0025905610*Close(index+22)
    +0.0059521459*Close(index+23)
    +0.0105212252*Close(index+24)
    +0.0096970755*Close(index+25)
    +0.0046585685*Close(index+26)
    -0.0017079230*Close(index+27)
    -0.0063513565*Close(index+28)
    -0.0074539350*Close(index+29)
    -0.0050439973*Close(index+30)
    -0.0007459678*Close(index+31)
    +0.0032271474*Close(index+32)
    +0.0051357867*Close(index+33)
    +0.0044454862*Close(index+34)
    +0.0018784961*Close(index+35)
    -0.0011065767*Close(index+36)
    -0.0031162862*Close(index+37)
    -0.0033443253*Close(index+38)
    -0.0022163335*Close(index+39)
    +0.0003650790*Close(index+41)
    +0.0060440751*Close(index+42)
    +0.0018747783*Close(index+43);

    value3 :=
    0.0982862174*Close(index+0)
    +0.0975682269*Close(index+1)
    +0.0961401078*Close(index+2)
    +0.0940230544*Close(index+3)
    +0.0912437090*Close(index+4)
    +0.0878391006*Close(index+5)
    +0.0838544303*Close(index+6)
    +0.0793406350*Close(index+7)
    +0.0743569346*Close(index+8)
    +0.0689666682*Close(index+9)
    +0.0632381578*Close(index+10)
    +0.0572428925*Close(index+11)
    +0.0510534242*Close(index+12)
    +0.0447468229*Close(index+13)
    +0.0383959950*Close(index+14)
    +0.0320735368*Close(index+15)
    +0.0258537721*Close(index+16)
    +0.0198005183*Close(index+17)
    +0.0139807863*Close(index+18)
    +0.0084512448*Close(index+19)
    +0.0032639979*Close(index+20)
    -0.0015350359*Close(index+21)
    -0.0059060082*Close(index+22)
    -0.0098190256*Close(index+23)
    -0.0132507215*Close(index+24)
    -0.0161875265*Close(index+25)
    -0.0186164872*Close(index+26)
    -0.0205446727*Close(index+27)
    -0.0219739146*Close(index+28)
    -0.0229204861*Close(index+29)
    -0.0234080863*Close(index+30)
    -0.0234566315*Close(index+31)
    -0.0231017777*Close(index+32)
    -0.0223796900*Close(index+33)
    -0.0213300463*Close(index+34)
    -0.0199924534*Close(index+35)
    -0.0184126992*Close(index+36)
    -0.0166377699*Close(index+37)
    -0.0147139428*Close(index+38)
    -0.0126796776*Close(index+39)
    -0.0105938331*Close(index+40)
    -0.0084736770*Close(index+41)
    -0.0063841850*Close(index+42)
    -0.0043466731*Close(index+43)
    -0.0023956944*Close(index+44)
    -0.0005535180*Close(index+45)
    +0.0011421469*Close(index+46)
    +0.0026845693*Close(index+47)
    +0.0040471369*Close(index+48)
    +0.0052380201*Close(index+49)
    +0.0062194591*Close(index+50)
    +0.0070340085*Close(index+51)
    +0.0076266453*Close(index+52)
    +0.0080376628*Close(index+53)
    +0.0083037666*Close(index+54)
    +0.0083694798*Close(index+55)
    +0.0082901022*Close(index+56)
    +0.0080741359*Close(index+57)
    +0.0077543820*Close(index+58)
    +0.0073260526*Close(index+59)
    +0.0068163569*Close(index+60)
    +0.0062325477*Close(index+61)
    +0.0056078229*Close(index+62)
    +0.0049516078*Close(index+63)
    +0.0161380976*Close(index+64);

    value4 :=
    -0.0074151919*Close(index+0)
    -0.0060698985*Close(index+1)
    -0.0044979052*Close(index+2)
    -0.0027054278*Close(index+3)
    -0.0007031702*Close(index+4)
    +0.0014951741*Close(index+5)
    +0.0038713513*Close(index+6)
    +0.0064043271*Close(index+7)
    +0.0090702334*Close(index+8)
    +0.0118431116*Close(index+9)
    +0.0146922652*Close(index+10)
    +0.0175884606*Close(index+11)
    +0.0204976517*Close(index+12)
    +0.0233865835*Close(index+13)
    +0.0262218588*Close(index+14)
    +0.0289681736*Close(index+15)
    +0.0315922931*Close(index+16)
    +0.0340614696*Close(index+17)
    +0.0363444061*Close(index+18)
    +0.0384120882*Close(index+19)
    +0.0402373884*Close(index+20)
    +0.0417969735*Close(index+21)
    +0.0430701377*Close(index+22)
    +0.0440399188*Close(index+23)
    +0.0446941124*Close(index+24)
    +0.0450230100*Close(index+25)
    +0.0450230100*Close(index+26)
    +0.0446941124*Close(index+27)
    +0.0440399188*Close(index+28)
    +0.0430701377*Close(index+29)
    +0.0417969735*Close(index+30)
    +0.0402373884*Close(index+31)
    +0.0384120882*Close(index+32)
    +0.0363444061*Close(index+33)
    +0.0340614696*Close(index+34)
    +0.0315922931*Close(index+35)
    +0.0289681736*Close(index+36)
    +0.0262218588*Close(index+37)
    +0.0233865835*Close(index+38)
    +0.0204976517*Close(index+39)
    +0.0175884606*Close(index+40)
    +0.0146922652*Close(index+41)
    +0.0118431116*Close(index+42)
    +0.0090702334*Close(index+43)
    +0.0064043271*Close(index+44)
    +0.0038713513*Close(index+45)
    +0.0014951741*Close(index+46)
    -0.0007031702*Close(index+47)
    -0.0027054278*Close(index+48)
    -0.0044979052*Close(index+49)
    -0.0060698985*Close(index+50)
    -0.0074151919*Close(index+51)
    -0.0085278517*Close(index+52)
    -0.0094111161*Close(index+53)
    -0.0100658241*Close(index+54)
    -0.0104994302*Close(index+55)
    -0.0107227904*Close(index+56)
    -0.0107450280*Close(index+57)
    -0.0105824763*Close(index+58)
    -0.0102517019*Close(index+59)
    -0.0097708805*Close(index+60)
    -0.0091581551*Close(index+61)
    -0.0084345004*Close(index+62)
    -0.0076214397*Close(index+63)
    -0.0067401718*Close(index+64)
    -0.0058083144*Close(index+65)
    -0.0048528295*Close(index+66)
    -0.0038816271*Close(index+67)
    -0.0029244713*Close(index+68)
    -0.0019911267*Close(index+69)
    -0.0010974211*Close(index+70)
    -0.0002535559*Close(index+71)
    +0.0005231953*Close(index+72)
    +0.0012297491*Close(index+73)
    +0.0018539149*Close(index+74)
    +0.0023994354*Close(index+75)
    +0.0028490136*Close(index+76)
    +0.0032221429*Close(index+77)
    +0.0034936183*Close(index+78)
    +0.0036818974*Close(index+79)
    +0.0038037944*Close(index+80)
    +0.0038338964*Close(index+81)
    +0.0037975350*Close(index+82)
    +0.0036986051*Close(index+83)
    +0.0035521320*Close(index+84)
    +0.0033559226*Close(index+85)
    +0.0031224409*Close(index+86)
    +0.0028550092*Close(index+87)
    +0.0025688349*Close(index+88)
    +0.0022682355*Close(index+89)
    +0.0073925495*Close(index+90);

  STLMBuffer[index] := value3-value4;
  FTLMBuffer[index] := value1-value2;
end;

exports

Init, Done, Calculate;

end.



