//---------------------------------------------------------------------------
// Bears Power
//---------------------------------------------------------------------------
library Bears_Power;

uses
  graphics, IndicatorInterfaceUnit, TechnicalFunctions;

var
  // External variables
  Period: integer;

  // Buffers
  Buffer, Bears: TIndexBuffer;

//---------------------------------------------------------------------------
// Initialize indicator
//---------------------------------------------------------------------------
procedure Init; stdcall;
begin
  // define properties
  IndicatorShortName('Bears Power');
  SetOutputWindow(ow_SeparateWindow);
  AddLevel(0, psDot, 1, cl_GridColor);

  // register options
  RegOption('Period', ot_Integer, Period);
  SetOptionRange('Period', 1, MaxInt);
  Period := 13;

  // create buffers
  Buffer := CreateIndexBuffer;
  Bears := CreateIndexBuffer;

  IndicatorBuffers(1);
  SetIndexBuffer(0, Bears);
  SetIndexStyle(0, ds_Histogram, psSolid, 1, clRed);
  SetIndexLabel(0, 'Bears power');
end;

//---------------------------------------------------------------------------
// Deinitialize indicator
//---------------------------------------------------------------------------
procedure Done; stdcall;
begin
end;

//---------------------------------------------------------------------------
// Calculate requested bar
//---------------------------------------------------------------------------
procedure Calculate(index: integer); stdcall;
begin
  Buffer[index] := GetMA(index, 0, Period, ma_EMA, pt_Close, Buffer[index + 1]);
  Bears[index]:= Low(index)-Buffer[index];
end;

exports

  Init, Done, Calculate;

end.
