//---------------------------------------------------------------------------
// Williams alligator
//---------------------------------------------------------------------------
library Alligator;

uses
  graphics, IndicatorInterfaceUnit, TechnicalFunctions;

var
  // External variables
  JawsPeriod: integer = 13;
  JawsShift: integer = 8;
  TeethPeriod: integer = 8;
  TeethShift: integer = 5;
  LipsPeriod: integer = 5;
  LipsShift: integer = 3;
  MAtype: integer;
  ApplyToPrice: integer;

  // Buffers
  Jaws, Teeth, Lips: TIndexBuffer;


//---------------------------------------------------------------------------
// Initialize indicator
//---------------------------------------------------------------------------
procedure Init; stdcall;
begin
  // define properties
  IndicatorShortName('Alligator (B. Williams)');
  SetOutputWindow(ow_ChartWindow);

  // register options
  AddSeparator('Common');

  RegMATypeOption(MAtype);
  MAtype := 3;

  RegApplyToPriceOption(ApplyToPrice);
  ApplyToPrice := 4;

  RegOption('Jaws period', ot_Integer, JawsPeriod);
  SetOptionRange('Jaws period', 1, MaxInt);
  RegOption('Jaws shift', ot_Integer, JawsShift);
  RegOption('Teeth period', ot_Integer, TeethPeriod);
  SetOptionRange('Teeth period', 1, MaxInt);
  RegOption('Teeth shift', ot_Integer, TeethShift);
  RegOption('Lips period', ot_Integer, LipsPeriod);
  SetOptionRange('Lips period', 1, MaxInt);
  RegOption('Lips shift', ot_Integer, LipsShift);

  // create buffers
  Jaws := CreateIndexBuffer;
  Teeth := CreateIndexBuffer;
  Lips := CreateIndexBuffer;

  IndicatorBuffers(3);

  SetIndexBuffer(0, Jaws);
  SetIndexStyle(0, ds_Line, psSolid, 1, clBlue);
  SetIndexLabel(0, 'Jaws');

  SetIndexBuffer(1, Teeth);
  SetIndexStyle(1, ds_Line, psSolid, 1, clRed);
  SetIndexLabel(1, 'Teeth');

  SetIndexBuffer(2, Lips);
  SetIndexStyle(2, ds_Line, psSolid, 1, clLime);
  SetIndexLabel(2, 'Lips');
end;

//---------------------------------------------------------------------------
// parameters changed
//---------------------------------------------------------------------------
procedure OnParamsChange; stdcall;
begin
  SetBufferShift(0, JawsShift);
  SetBufferShift(1, TeethShift);
  SetBufferShift(2, LipsShift);
end;

//---------------------------------------------------------------------------
// Calculate requested bar
//---------------------------------------------------------------------------
procedure Calculate(index: integer); stdcall;

  procedure Calc(index, period: integer; buff: TIndexBuffer);
  begin
    buff[index] := GetMA(index, 0, period, TMAType(MAType),
      TPriceType(ApplyToPrice), buff[index + 1]);
  end;

begin
  Calc(index, JawsPeriod, Jaws);
  Calc(index, TeethPeriod, Teeth);
  Calc(index, LipsPeriod, Lips);
end;

exports

Init, OnParamsChange, Calculate;

end.
