//---------------------------------------------------------------------------
// AMA - Adaptive Moving Average Indicator
// Written by Oleg Polovinkin
// Version 0.1
//---------------------------------------------------------------------------
library AMA;

uses
  graphics, IndicatorInterfaceUnit, TechnicalFunctions;

var
  // External variables
  Period: integer = 10;
  Shift: integer = 0;
  ApplyToPrice: integer;
  FastMA: integer = 3;
  SlowMA: integer = 100;

  // Buffers
  AMABuf: TIndexBuffer;

//---------------------------------------------------------------------------
// Initialize indicator
//---------------------------------------------------------------------------
procedure Init; stdcall;
begin
  // define properties
  IndicatorShortName('Adaptive Moving Average (AMA)');
  SetOutputWindow(ow_ChartWindow);

  // register options
  AddSeparator('Common');

  RegOption('Fast MA Period', ot_Integer, FastMA);
  SetOptionRange('FastMA', 1, MaxInt);
  RegOption('Slow MA Period', ot_Integer, SlowMA);
  SetOptionRange('SlowMA', 1, MaxInt);
  RegOption('AMA Period', ot_Integer, Period);
  SetOptionRange('Period', 1, MaxInt);
  RegOption('AMA Shift', ot_Integer, Shift);
  RegApplyToPriceOption(ApplyToPrice);

  // create buffers
  AMABuf := CreateIndexBuffer;

  IndicatorBuffers(1);
  SetIndexBuffer(0, AMABuf);
  SetIndexStyle(0, ds_Line, psSolid, 1, clGreen);
  SetIndexLabel(0, 'AMA');
end;

//---------------------------------------------------------------------------
// parameters changed
//---------------------------------------------------------------------------
procedure OnParamsChange; stdcall;
begin
  SetBufferShift(0, Shift);
end;

//---------------------------------------------------------------------------
// Calculate requested bar
//---------------------------------------------------------------------------
procedure Calculate(index: integer); stdcall;
var
  i: integer;
  SSC, ER, Volatility: double;
  k1, k2: double;

  function Price(index: integer): double;
  begin
    result := GetPrice(index, TPriceType(ApplyToPrice));
  end;

begin
  // for this index values are not defined
  if (index + period) >= Bars then
    exit;

  // first value
  if AMABuf[index + 1] = 0 then
    begin
      AMABuf[index] := Price(index);
      exit;
    end;

  Volatility := 0;
  for i := 0 to (Period - 1) do
    Volatility := Volatility + abs(Price(index + i) - Price(index + i + 1));

  if Volatility <> 0 then
    ER := (Price(index) - Price(index + Period))/Volatility
  else
    ER := 0;

  k1 := 2.0/(FastMA + 1);
  k2 := 2.0/(SlowMA + 1);

  SSC := ER*(k1 - k2) + k2;

  AMABuf[index] := AMABuf[index + 1] + SSC*SSC*(Price(index) - AMABuf[index + 1]);
end;

exports

Init, OnParamsChange, Calculate;

end.

