//---------------------------------------------------------------------------
// Accelerator Oscillator(AC)
//---------------------------------------------------------------------------
library AC;

uses
  SysUtils,
  Classes,
  graphics,
  windows,
  IndicatorInterfaceUnit,
  TechnicalFunctions in 'TechnicalFunctions.pas';

var
  // External variables
  periodF, periodS, periodSAC: integer;
  MAtype: integer;
  ApplyToPrice: integer;

  // Buffers
  SMA1, SMA2, SMAF, SMAS, SMA, SMAAC : TIndexBuffer;


//---------------------------------------------------------------------------
// Initialize indicator
//---------------------------------------------------------------------------
procedure Init; stdcall;
begin
  // define properties
  IndicatorShortName('Accelerator Oscillator (B. Williams)');
  SetOutputWindow(ow_SeparateWindow);
  AddLevel(0, psDot, 1, cl_GridColor);
  SetEmptyValue(0);

  // register options
  AddSeparator('Common');

  RegOption('PeriodF', ot_Integer, periodF);
  SetOptionRange('PeriodF', 1, MaxInt);
  periodF := 5;

  RegOption('PeriodS', ot_Integer, periodS);
  SetOptionRange('PeriodF', 1, MaxInt);
  periodS := 34;

  RegOption('PeriodSAC', ot_Integer, periodSAC);
  SetOptionRange('PeriodF', 1, MaxInt);
  periodSAC := 5;

  RegMATypeOption(MAtype);

  RegApplyToPriceOption(ApplyToPrice);

  // create buffers
  SMA := CreateIndexBuffer;
  SMAF := CreateIndexBuffer;
  SMAS := CreateIndexBuffer;
  SMAAC := CreateIndexBuffer;
  SMA1 := CreateIndexBuffer;
  SMA2 := CreateIndexBuffer;

  IndicatorBuffers(2);
  SetIndexBuffer(0, SMA1);
  SetIndexStyle(0, ds_Histogram, psSolid, 3, clLime);
  SetIndexLabel(0, 'AC 1');
  SetIndexBuffer(1, SMA2);
  SetIndexStyle(1, ds_Histogram, psSolid, 3, clRed);
  SetIndexLabel(1, 'AC 2');
end;

//---------------------------------------------------------------------------
// Deinitialize indicator
//---------------------------------------------------------------------------
procedure Done; stdcall;
begin

end;

//---------------------------------------------------------------------------
// Calculate requested bar
//---------------------------------------------------------------------------
procedure Calculate(index: integer); stdcall;
var
  i: integer;
  sum, current, prev: double;
begin
  if (index + PeriodF >= Bars) or (index + PeriodS >= Bars) then
    exit;

  SMAF[index] := GetMA(index, 0, PeriodF, TMAType(MAtype), TPriceType(ApplyToPrice));
  SMAS[index] := GetMA(index, 0, PeriodS, TMAType(MAtype), TPriceType(ApplyToPrice));
  SMA[index] := SMAF[index] -  SMAS[index];

  sum := 0;
  for i:=index to index + periodSAC - 1 do
    sum := sum + SMA[i];
  SMAAC[index] := sum/periodSAC;

  current := SMA[index] - SMAAC[index];
  prev := SMA[index+1] - SMAAC[index+1];

  if (current < prev) then
    begin
      SMA2[index] := current;
      SMA1[index] := 0;
    end
  else
    begin
      SMA1[index] := current;
      SMA2[index] := 0;
    end;
end;

exports

Init, Done, Calculate;

end.


