//---------------------------------------------------------------------------
// Price channel
//---------------------------------------------------------------------------
library PriceChannel;

uses
  graphics,
  IndicatorInterfaceUnit,
  TechnicalFunctions in 'TechnicalFunctions.pas';

var
  // External variables
  period: integer;

  // Buffers
  UpBuff, DownBuff: TIndexBuffer;


//---------------------------------------------------------------------------
// Initialize indicator
//---------------------------------------------------------------------------
procedure Init; stdcall;
begin
  // define properties
  IndicatorShortName('Price channel');
  SetOutputWindow(ow_ChartWindow);

  // register options
  AddSeparator('Common');

  RegOption('Period', ot_Integer, period);
  SetOptionRange('Period', 1, MaxInt);
  period := 12;

  // create buffers
  IndicatorBuffers(2);
  UpBuff := CreateIndexBuffer;
  DownBuff := CreateIndexBuffer;
  SetIndexBuffer(0, UpBuff);
  SetIndexStyle(0, ds_Line, psSolid, 1, clRed);
  SetIndexLabel(0, 'Up Band');
  SetIndexBuffer(1, DownBuff);
  SetIndexStyle(1, ds_Line, psSolid, 1, clRed);
  SetIndexLabel(1, 'Down Band');
end;

//---------------------------------------------------------------------------
// Deinitialize indicator
//---------------------------------------------------------------------------
procedure Done; stdcall;
begin

end;

//---------------------------------------------------------------------------
// Calculate requested bar
//---------------------------------------------------------------------------
procedure Calculate(index: integer); stdcall;
begin
  UpBuff[index] := GetHighestValue(vt_High, index, period);
  DownBuff[index] := GetLowestValue(vt_Low, index, period);
end;

exports

Init, Done, Calculate;

end.
