//---------------------------------------------------------------------------
// Parabolic SAR
//---------------------------------------------------------------------------
library PRSAR;

uses
  SysUtils,
  classes,
  graphics,
  windows,
  IndicatorInterfaceUnit,
  TechnicalFunctions in 'TechnicalFunctions.pas';

var
  //  
  StartPR, StepPR, EndPR: double;

  //  
  SAR : TIndexBuffer;

  first, newBar: boolean;
  LastTime: TDateTime;
  CurPR: double;


  //---------------------------------------------------------------------------
//  
//---------------------------------------------------------------------------
procedure Init; stdcall;
begin
  //  
  IndicatorShortName('Parabolik-SAR');
  SetOutputWindow(ow_ChartWindow);

  //  
  AddSeparator('Common');

  RegOption('StartPR', ot_double, StartPR);
  //SetOptionRange('StartPR', 1, MaxInt);
  SetOptionDigits('StartPR', 4);
  StartPR := 0.0200;

  RegOption('StepPR', ot_double, StepPR);
  //SetOptionRange('StartPR', 1, MaxInt);
  SetOptionDigits('StepPR', 4);
  StepPR := 0.0200;

  RegOption('EndPR', ot_double, EndPR);
  //SetOptionRange('StartPR', 1, MaxInt);
  SetOptionDigits('EndPR', 4);
  EndPR := 0.2000;

  //   
  sar  := CreateIndexBuffer;

  IndicatorBuffers(1);

  SetIndexBuffer(0, sar);
  SetIndexStyle (0, ds_Symbol, psSolid, 1, clRed);
  SetIndexSymbol(0, 158, 0, 0);
  SetEmptyValue (0.0);

  first := true;
  newBar := False;
  LastTime := 0;
end;

//---------------------------------------------------------------------------
//  
//---------------------------------------------------------------------------
procedure Done; stdcall;
begin
  //
end;

//---------------------------------------------------------------------------
//    
//---------------------------------------------------------------------------
procedure Calculate(index: integer); stdcall;
var
  i, LastBarsCount: integer;
  CurHigh, CurLow: real;
  SRp, SRc: real;
  moveUP, moveDown: Boolean;

  //------------------------------------------------------------------

  procedure FindFirstPoint;
  var
    find: boolean;
    hi, hi_1, li, li_1: double;
  begin
    find := false;
    i := Bars - 1;
    while not find do
      begin
        hi := High(i);
        li := Low(i);
        hi_1 := High(i + 1);
        li_1 := Low(i + 1);

        if (((hi = hi_1) and (li = li_1) or
           (((hi > hi_1) and (li < li_1)) and
            ((hi - hi_1) = (li_1 - li))) or
           (((hi < hi_1) and (li > li_1)) and
            ((hi - hi_1) = (li_1 - li))))) then
          begin
            sar[i] := 0;
            i := i - 1;
          end
        else
          begin
            if ((hi > hi_1) and
               ((li >= li_1) or
               ((li < li_1) and
               ((li_1 - li) < (hi - hi_1))))) then
              begin
                MoveUp := True;
                MoveDown := False;
                SRp := li_1;
                CurHigh := hi_1;
                SRc := SRp + StartPr*(CurHigh - SRp);
                SAR[i] := SRc;
                CurHigh := hi;
                CurPR := StepPR + startPR;
                SRp := SRc;
              end;

            if ((li < li_1) and
               ((hi <= hi_1) or
               ((hi > hi_1) and
               ((hi - hi_1) < (li_1 - li))))) then
              begin
                MoveUp := False;
                MoveDown := True;
                SRp := hi_1;
                CurLow := li_1;
                SRc := SRp + StartPr*(CurLow - SRp);
                SAR[i] := SRc;
                CurLow := li;
                CurPR := StepPR + startPR;
                SRp := SRc;
              end;

            i := i - 1;
            find := true;
          end;
      end; {while}
  end;

  //------------------------------------------------------------------
  //   
  //------------------------------------------------------------------
  procedure MainLoop;
  begin
    while i >= 0 do
      begin
        //   
        if MoveUp then begin
         if (High(i) > CurHigh) then begin
          CurHigh:=High(i);
          if (CurPR+StepPR)< EndPR then begin
           CurPr:=curPR+StepPR;
          end else begin
           CurPR:=endPR;
          end
         end;

         SRc:=SRp+CurPR*(CurHigh-SRp);

         if (SRc < Low(i)) then begin
             SRp:=SRc;
         end else begin
            MoveUp:=false;
            MoveDown:=True;
            SRc:=CurHigh;
            CurLow:=Low(i);
            CurPR:=StartPR;
            SRp:=SRc;
            //SRc:=SRp+CurPR*(CurLow-SRp);
            //SAR[i]:=SRc;
         end;
        end else begin   //   
         if (Low(i)<CurLow) then begin
           CurLow:=Low(i);
           if (CurPR+StepPR) < EndPR then begin
              CurPR:=CurPR+StepPR;
           end else begin
              CurPR:=EndPR;
           end;
         end;

         SRc:=SRp+CurPR*(CurLow-SRp);

         if (SRc > High(i)) then begin
             SRp:=SRc;
         end else begin
            MoveUp:=true;
            MoveDown:=False;
            SRc:=CurLow;
            SRp:=SRc;
            CurHigh:=High(i);
            CurPR:=StartPR;
            //SRc:=SRp+CurPR*(CurHigh-SRp);
            //SAR[i]:=SRc;
         end;
        end;
        SAR[i]:=SRc;
        //Print(format('SAR: %.4f, %d, %s, %.4f, %.4f, %.4f, %.4f  ', [SAR[i],i, DateTimetoStr(time(i)),SRp, CurPR, CurHigh, CurLow]));
        i:=i-1;
      end;

    LastBarsCount := Bars;     // -     
  end;

  //------------------------------------------------------------------
  //     
  // (        ,   .
  //    ,      .
  //  ,       /   
  //   .        
  //------------------------------------------------------------------
procedure CurrentBarCheck;
begin
{
 if (Close(i) > High(i)) or
    (Close(i) < Low(i)) then begin
      if MoveUP then begin
        SRc:=SRp+CurPR*(CurHigh-SRp);
        if Close(i)<= SRc then begin
          ;
        end ;
      end else begin
        SRc:=SRp+CurPR*(CurLow-SRp);
        if Close(i)>=SRc then begin
          ;
        end;
      end;
 end;
 };
end;

  //------------------------------------------------------------------
  //   
  //------------------------------------------------------------------
begin
  if (index <> 0) or (Bars < 5) then
    exit;
  sar[Bars]:=0.0;


  if Time(0) = LastTime then
    begin
      newbar := false;
      CurrentBarCheck;
    end
  else
    newbar := true;

  //               
  //       ( ) ,    
  if first or newbar or (LAstBarsCount > Bars) then
    begin
      FindFirstPoint;
      MainLoop;
      first := false;
      newbar := false;
    end;
end;


exports
  Init, Done, Calculate;

end.


