//---------------------------------------------------------------------------
// Moving average indicator (SMA, EMA, WMA, SSMA)
//---------------------------------------------------------------------------
library MovingAverage;

uses
  graphics,
  IndicatorInterfaceUnit,
  TechnicalFunctions in 'TechnicalFunctions.pas';

var
  // External variables
  period: integer = 8;
  Shift: integer = 0;
  MAtype: integer = 0;
  ApplyToPrice: integer = 0;
  VShift: integer = 0;

  // Buffers
  SMA, SSMA: TIndexBuffer;


//---------------------------------------------------------------------------
// Initialize indicator
//---------------------------------------------------------------------------
procedure Init; stdcall;
begin
  // define properties
  IndicatorShortName('Moving average');
  SetOutputWindow(ow_ChartWindow);
  SetEmptyValue(0);

  // register options
  AddSeparator('Common');

  RegOption('Period', ot_Integer, period);
  SetOptionRange('Period', 1, MaxInt);
  RegOption('HShift', ot_Integer, Shift);
  RegOption('VShift', ot_Integer, VShift);
  RegMATypeOption(MAtype);

  RegApplyToPriceOption(ApplyToPrice);

  // create buffers
  SMA := CreateIndexBuffer;
  SSMA := CreateIndexBuffer;

  IndicatorBuffers(1);
  SetIndexBuffer(0, SSMA);
  SetIndexStyle(0, ds_Line, psSolid, 1, clYellow);
  SetIndexLabel(0, 'MA');
end;

//---------------------------------------------------------------------------
// parameters changed
//---------------------------------------------------------------------------
procedure OnParamsChange; stdcall;
begin
  SetBufferShift(1, Shift);
end;

//---------------------------------------------------------------------------
// Calculate requested bar
//---------------------------------------------------------------------------
procedure Calculate(index: integer); stdcall;
begin
  if index + period >= Bars then
    exit;

  SMA[index] := GetMA(index, 0, period, TMAType(MAtype), TPriceType(ApplyToPrice),
    SMA[index + 1]);

  SSMA[index] := SMA[index] + VShift*Point;
end;

exports

Init, Calculate, OnParamsChange;

end.
