//---------------------------------------------------------------------------
// Bulls Power
//---------------------------------------------------------------------------
library Bulls_Power;

uses
  graphics, IndicatorInterfaceUnit, TechnicalFunctions;

var
  // External variables
  Period: integer;

  // Buffers
  Buffer, Bulls: TIndexBuffer;

//---------------------------------------------------------------------------
// Initialize indicator
//---------------------------------------------------------------------------
procedure Init; stdcall;
begin
  // define properties
  IndicatorShortName('Bulls Power');
  SetOutputWindow(ow_SeparateWindow);
  AddLevel(0, psDot, 1, cl_GridColor);

  // register options
  RegOption('Period', ot_Integer, Period);
  SetOptionRange('Period', 1, MaxInt);
  Period := 13;

  // create buffers
  Buffer := CreateIndexBuffer;
  Bulls := CreateIndexBuffer;

  IndicatorBuffers(1);
  SetIndexBuffer(0, Bulls);
  SetIndexStyle(0, ds_Histogram, psSolid, 1, clSilver);
  SetIndexLabel(0, 'Bulls power');
end;

//---------------------------------------------------------------------------
// Deinitialize indicator
//---------------------------------------------------------------------------
procedure Done; stdcall;
begin
end;

//---------------------------------------------------------------------------
// Calculate requested bar
//---------------------------------------------------------------------------
procedure Calculate(index: integer); stdcall;
begin
  Buffer[index] := GetMA(index, 0, Period, ma_EMA, pt_Close, Buffer[index + 1]);
  Bulls[index] := High(index) - Buffer[index];
end;

exports

  Init, Done, Calculate;

end.
