library wlxZZ_DT;

{  ZigZag        
               .

   Depth   - ,      
   ()  ()  Deviation ,  ,  
    ZigZag  ,   (  ) ,
     Deviation, ZigZag    Depth .
   Backstep       ().

    ,  ZigZag   ,    
      ,        
   .      ,  (   
     )  ZigZag    (  
    )   .

          .

 }

uses
  SysUtils,
  classes,
  graphics,
  windows,
  IndicatorInterfaceUnit,
  TechnicalFunctions in 'TechnicalFunctions.pas';

var
  Depth   :integer;

  //  
  ZZ : TIndexBuffer;
  zzH: TIndexBuffer;
  zzL: TIndexBuffer;
  zzHPos: TIndexBuffer;
  zzLPos: TIndexBuffer;


//---------------------------------------------------------------------------
//  
//---------------------------------------------------------------------------
procedure Init; stdcall;
begin
  IndicatorShortName('wlxZZ-DT');
  SetOutputWindow(ow_ChartWindow);

  //  
  AddSeparator('Common');

  RegOption('Depth', ot_Integer, Depth);
  SetOptionRange('Depth', 1, MaxInt);
  Depth := 12;

  //   
  zz  := CreateIndexBuffer;
  zzH := CreateIndexBuffer;
  zzL := CreateIndexBuffer;
  zzHPos := CreateIndexBuffer;
  zzLPos := CreateIndexBuffer;

  IndicatorBuffers(1);

  SetIndexBuffer(0, zz);
  SetIndexStyle (0, ds_Section, psSolid, 2, clYellow);
  SetEmptyValue(0.0);
end;

//---------------------------------------------------------------------------
//  
//---------------------------------------------------------------------------
procedure Done; stdcall;
begin

end;

//---------------------------------------------------------------------------
//    
//---------------------------------------------------------------------------
procedure Calculate(index: integer); stdcall;
var
  cnt, i, shift, pos, lasthighpos, lastlowpos, curhighpos, curlowpos: integer;
  curlow, curhigh, lasthigh, lastlow: double;
  cmin, cmax: double;

  //------------------------------------------------------------------
  function LowestPos(sh: integer; cnt: integer): integer;
  var
    lmin: double;
    j, clow: integer;
  begin
    lmin := Low(sh);
    clow := sh;
    for j:=sh to sh+cnt do
      if lmin > Low(j) then
        begin
          lmin := Low(j);
          clow := j;
        end;
    result := clow;
  end;

  //------------------------------------------------------------------
  function HighestPos(sh: integer; cnt: integer): integer;
  var
    lmax: double;
    j, chigh: integer;
  begin
    lmax := High(sh);
    chigh := sh;
    for j:=sh to sh+cnt do
     if lmax < High(j) then
       begin
         lmax := High(j);
         chigh := j;
       end;
    result := chigh;
  end;

begin
  if (index + depth >= Bars) or (index <> 0) then
    exit;

  cnt := 0;
  pos := Bars - 1;
  for shift:=0 to Bars - 1 do
    begin
      if zz[shift] <> 0 then
        inc(cnt);
      if cnt = 2 then
        begin
          pos := shift - 1;
          break;
        end;
    end;

  if pos = Bars - 1 then
    begin
      LastHighPos := pos;
      LastLowPos := pos;
    end
  else
    begin
      LastHighPos := round(zzHPos[pos + 1]);
      LastLowPos := round(zzLPos[pos + 1]);
    end;

  LastLow := Low(LastLowPos);
  LastHigh := High(LastHighPos);

  for shift:=pos downto 0 do
    begin
      zz[shift] := 0;
      zzH[shift] := 0;
      zzL[shift] := 0;
      CurLowPos := LowestPos(shift, depth);
      CurLow := Low(CurLowPos);
      CurHighPos := HighestPos(shift, depth);
      CurHigh := High(CurHighPos);

      if (CurLow >= LastLow) then
        LastLow := CurLow
      else
        begin
          if (LastHighPos > CurLowPos) then
            begin
              zzL[CurLowPos] := CurLow;
              cmin := 100000;
              pos := LastHighPos;
              for i:=LastHighPos downto CurLowPos do
                begin
                  if (zzL[i] = 0) then continue;
                  if (zzL[i] < cmin) then
                    begin
                      cmin := zzL[i];
                      pos := i;
                    end;
                  zz[i] := 0;
                end;
             zz[pos] := cmin;
          end;
          LastLowPos := CurLowPos;
          LastLow := CurLow;
       end;

      if (CurHigh <= LastHigh) then
        LastHigh := CurHigh
      else
        begin
          if (LastLowPos > CurHighPos) then
            begin
              zzH[CurHighPos] := CurHigh;
              cmax := -100000;
              pos := LastLowPos;
              for i:=LastLowPos downto CurHighPos do
                begin
                  if (zzH[i] = 0) then continue;
                  if (zzH[i] > cmax) then
                    begin
                      cmax := zzH[i];
                      pos := i;
                    end;
                  zz[i] := 0;
                end;
              zz[pos] := cmax;
            end;
          LastHighPos := CurHighPos;
          LastHigh := CurHigh;
       end;

      zzHPos[shift] := LastHighPos;
      zzLPos[shift] := LastLowPos;
    end;  {for}
end;



exports

//       

Init, Done, Calculate;



end.


