//---------------------------------------------------------------------------
// WPR
//---------------------------------------------------------------------------
library WPR;

uses
  SysUtils, Math, graphics, IndicatorInterfaceUnit, TechnicalFunctions;

var
  // External variables
  Period: integer;
  ApplyToPrice: integer;

  // Buffers
  WPRBuffer: TIndexBuffer;

//---------------------------------------------------------------------------
// Initialize indicator
//---------------------------------------------------------------------------
procedure Init; stdcall;
begin
  // define properties
  IndicatorShortName('Williams'' Percent Range (%R)');
  SetOutputWindow(ow_SeparateWindow);
  SetFixedMinMaxValues(-100, 0);
  SetEmptyValue(10);
  AddLevel(-20, psDot, 1, clGray);
  AddLevel(-80, psDot, 1, clGray);

  // register options
  AddSeparator('Common');

  RegOption('Period', ot_Integer, Period);
  SetOptionRange('Period', 1, MaxInt);
  Period := 14;

  RegApplyToPriceOption(ApplyToPrice);

  // create buffers
  WPRBuffer := CreateIndexBuffer;

  IndicatorBuffers(1);
  SetIndexBuffer(0, WPRBuffer);
  SetIndexStyle(0, ds_Line, psSolid, 1, clRed);
  SetIndexLabel(0, '%R');
end;

//---------------------------------------------------------------------------
// Deinitialize indicator
//---------------------------------------------------------------------------
procedure Done; stdcall;
begin

end;

//---------------------------------------------------------------------------
// Calculate requested bar
//---------------------------------------------------------------------------
procedure Calculate(index: integer); stdcall;
var
  dMaxHigh, dMinLow: double;

  function HighestLowest(Mode: integer): double;
  var
    i: byte;
    Value: double;
  begin
    case Mode of
      0:  begin
            result := High(index);
            for i:=1 to Period - 1 do
              begin
                Value := High(index + i);
                if (Value > result) then
                  result := Value;
              end;
          end;
      else
          begin
            result := Low(index);
            for i:=1 to Period - 1 do
              begin
                Value := Low(index + i);
                if (Value < result) then
                  result := Value;
              end;
          end;
    end;
  end;

begin
  dMaxHigh := HighestLowest(0);
  dMinLow := HighestLowest(1);
  if (dMaxHigh - dMinLow) = 0 then
    WPRBuffer[index] := 0
  else
    WPRBuffer[index] := -100*(dMaxHigh - GetPrice(index, TPriceType(ApplyToPrice)))/(dMaxHigh - dMinLow);
end;

exports

  Init, Done, Calculate;

end.
