//---------------------------------------------------------------------------
// MACD indicator new
//---------------------------------------------------------------------------
library MACDnew;

uses
  SysUtils, classes, graphics, windows, IndicatorInterfaceUnit,
  TechnicalFunctions;

var
  // External variables
  FastEMAPeriod: integer;
  SlowEMAPeriod: integer;
  SMAPeriod: integer;
  ApplyToPrice: integer;

  // Buffers
  FastEMA, SlowEMA, _MACD, SMA, Diff: TIndexBuffer;


//---------------------------------------------------------------------------
// Initialize indicator
//---------------------------------------------------------------------------
procedure Init; stdcall;
begin
  // define properties
  IndicatorShortName('MACD new');
  SetOutputWindow(ow_SeparateWindow);
  AddLevel(0, psDot, 1, cl_GridColor);

  // register options
  AddSeparator('Common');

  RegOption('Fast EMA period', ot_Integer, FastEMAPeriod);
  SetOptionRange('Fast EMA period', 1, MaxInt);
  FastEMAPeriod := 5;

  RegOption('Slow EMA period', ot_Integer, SlowEMAPeriod);
  SetOptionRange('Slow EMA period', 1, MaxInt);
  SlowEMAPeriod := 13;

  RegOption('SMA period', ot_Integer, SMAPeriod);
  SetOptionRange('SMA period', 1, MaxInt);
  SMAPeriod := 3;

  RegApplyToPriceOption(ApplyToPrice);

  // create buffers
  FastEMA := CreateIndexBuffer;
  SlowEMA := CreateIndexBuffer;
  _MACD := CreateIndexBuffer;
  SMA := CreateIndexBuffer;
  Diff := CreateIndexBuffer;

  IndicatorBuffers(3);
  SetIndexBuffer(0, _MACD);
  SetIndexStyle(0, ds_Line, psSolid, 1, clBlue);
  SetIndexLabel(0, 'MACD');

  SetIndexBuffer(1, SMA);
  SetIndexStyle(1, ds_Line, psDot, 1, clRed);
  SetIndexLabel(1, 'Signal Line');

  SetIndexBuffer(2, Diff);
  SetIndexStyle(2, ds_Histogram, psSolid, 1, clSilver);
  SetIndexLabel(2, 'MACD - Signal');
end;

//---------------------------------------------------------------------------
// Deinitialize indicator
//---------------------------------------------------------------------------
procedure Done; stdcall;
begin

end;

//---------------------------------------------------------------------------
// Calculate requested bar
//---------------------------------------------------------------------------
procedure Calculate(index: integer); stdcall;
var
  i: integer;
  sum: double;
begin
  FastEMA[index] := GetMA(index, 0, FastEMAPeriod, ma_EMA, TPriceType(ApplyToPrice), FastEMA[index + 1]);
  SlowEMA[index] := GetMA(index, 0, SlowEMAPeriod, ma_EMA, TPriceType(ApplyToPrice), SlowEMA[index + 1]);
  _MACD[index] := FastEMA[index] - SlowEMA[index];

  sum := 0;
  for i:=index to index + SMAPeriod - 1 do
    sum := sum + _MACD[i];
  SMA[index] := sum/SMAPeriod;

  Diff[index] := _MACD[index] - SMA[index];
end;

exports

Init, Done, Calculate;

end.
