//---------------------------------------------------------------------------
// Keltner Channels
//---------------------------------------------------------------------------
library Keltner;

uses
  graphics, IndicatorInterfaceUnit, TechnicalFunctions;

var
  // External variables
  Period: integer;

  // Buffers
  Upper, Middle, Lower: TIndexBuffer;


//---------------------------------------------------------------------------
// Initialize indicator
//---------------------------------------------------------------------------
procedure Init; stdcall;
begin
  // define properties
  IndicatorShortName('Keltner Channels');
  SetOutputWindow(ow_ChartWindow);

  // register options
  RegOption('Period', ot_Integer, Period);
  SetOptionRange('Period', 1, MaxInt);
  Period := 10;

  // create buffers
  IndicatorBuffers(3);
  Upper := CreateIndexBuffer;
  Middle := CreateIndexBuffer;
  Lower := CreateIndexBuffer;

  SetIndexBuffer(0, Upper);
  SetIndexStyle(0, ds_Line, psSolid, 1, clLime);
  SetIndexLabel(0, 'Upper band');
  SetIndexBuffer(1, Middle);
  SetIndexStyle(1, ds_Line, psSolid, 1, clRed);
  SetIndexLabel(1, 'Middle band');
  SetIndexBuffer(2, Lower);
  SetIndexStyle(2, ds_Line, psSolid, 1, clLime);
  SetIndexLabel(2, 'Lower band');
end;

//---------------------------------------------------------------------------
// Deinitialize indicator
//---------------------------------------------------------------------------
procedure Done; stdcall;
begin

end;

//---------------------------------------------------------------------------
// Calculate requested bar
//---------------------------------------------------------------------------
procedure Calculate(index: integer); stdcall;
var
  avg:double;

  function FindAvg(s: integer): double;
  var
    i: integer;
    sum :double;
  begin
    sum := 0;
    for i:=s to s + period - 1 do
      sum := sum + High(i) - Low(i);
    Result := sum/period;
  end;

begin
  if index + Period >= Bars then
    exit;

  Middle[index] := GetMA(index, 0, Period, ma_SMA, pt_HLC3, Middle[index + 1]);
  avg:= FindAvg( index);

  Upper[index] := Middle[index] + avg;
  Lower[index] := Middle[index] - avg;
end;


exports

Init, Done, Calculate;

end.
