library FT_DCCI;

{
  // DoubleCCI Indicator for Forex Tester based on
  // originally written indicator by Jason Robinson (jnrtrading).
  // http://www.jnrtrading.co.uk for MetaTrader 4
  //
  // FT version by A.Veliks aka "wellx", 2007
  // aveliks@gmail.com
}

uses
  SysUtils,
  classes,
  graphics,
  windows,
  IndicatorInterfaceUnit,
  TechnicalFunctions in 'TechnicalFunctions.pas';

var
  //  
  
  TrendCCI_Period: Integer;
  EntryCCI_Period: Integer;
  Zero_Cross_Alert: boolean;
  Automatic_Timeframe_Setting:boolean;
  M1_TrendCCI_Period, M1_EntryCCI_Period: integer;
  M5_TrendCCI_Period, M5_EntryCCI_Period: integer;
  M15_TrendCCI_Period, M15_EntryCCI_Period: integer;
  M30_TrendCCI_Period, M30_EntryCCI_Period: integer;
  H1_TrendCCI_Period, H1_EntryCCI_Period: integer;
  H4_TrendCCI_Period, H4_EntryCCI_Period: integer;
  D1_TrendCCI_Period, D1_EntryCCI_Period: integer;
  W1_TrendCCI_Period, W1_EntryCCI_Period: integer;
  // MN1_TrendCCI_Period, MN1_EntryCCI_Period: integer;



  //  
  TrendCCI, EntryCCI, CCITrendUp,
  CCITrendDown, CCINoTrend, CCITimeBar, ZeroLine:TIndexBuffer;
  MATCCIBuffer, MAECCIBuffer: TIndexBuffer;

//---------------------------------------------------------------------------
//  
//---------------------------------------------------------------------------

procedure Init; stdcall;

begin
  //  
  IndicatorShortName('DoubleCCI');
  SetOutputWindow(ow_SeparateWindow );

  //  
  AddSeparator('Common');

  RegOption('TrendCCI_Period', ot_integer, TrendCCI_Period);
  TrendCCI_Period := 14;
  RegOption('EntryCCI_Period', ot_integer, EntryCCI_Period);
  EntryCCI_Period := 6;
  RegOption('Zero_Cross_Alert', ot_boolean, Zero_Cross_Alert);
  Zero_Cross_Alert := False;
  RegOption('Automatic_Timeframe_Setting', ot_boolean, Automatic_Timeframe_Setting);
  Automatic_Timeframe_Setting := False;
  RegOption('M1_TrendCCI_Period', ot_integer, M1_TrendCCI_Period);
  M1_TrendCCI_Period := 50;
  RegOption('M1_EntryCCI_Period', ot_integer, M1_EntryCCI_Period);
  M1_EntryCCI_Period := 14;
  RegOption('M5_TrendCCI_Period', ot_integer, M5_TrendCCI_Period);
  M5_TrendCCI_Period := 50;
  RegOption('M5_EntryCCI_Period', ot_integer, M5_EntryCCI_Period);
  M5_EntryCCI_Period := 14;
  RegOption('M15_TrendCCI_Period', ot_integer, M15_TrendCCI_Period);
  M15_TrendCCI_Period := 14;
  RegOption('M15_EntryCCI_Period', ot_integer, M15_EntryCCI_Period);
  M15_EntryCCI_Period := 6;
  {
  RegOption('M30_TrendCCI_Period', ot_integer, M30_TrendCCI_Period);
  M30_TrendCCI_Period := 14;
  RegOption('M30_EntryCCI_Period', ot_integer, M30_EntryCCI_Period);
  M30_EntryCCI_Period := 6;
  }
  RegOption('H1_TrendCCI_Period', ot_integer, H1_TrendCCI_Period);
  H1_TrendCCI_Period := 14;
  RegOption('H1_EntryCCI_Period', ot_integer, H1_EntryCCI_Period);
  H1_EntryCCI_Period := 6;
  RegOption('H4_TrendCCI_Period', ot_integer, H4_TrendCCI_Period);
  H4_TrendCCI_Period := 14;
  RegOption('H4_EntryCCI_Period', ot_integer, H4_EntryCCI_Period);
  H4_EntryCCI_Period := 6;
  RegOption('D1_TrendCCI_Period', ot_integer, D1_TrendCCI_Period);
  D1_TrendCCI_Period := 14;
  RegOption('D1_EntryCCI_Period', ot_integer, D1_EntryCCI_Period);
  D1_EntryCCI_Period := 6;
  RegOption('W1_TrendCCI_Period', ot_integer, W1_TrendCCI_Period);
  W1_TrendCCI_Period := 14;
  RegOption('W1_EntryCCI_Period', ot_integer, W1_EntryCCI_Period);
  W1_EntryCCI_Period := 6;
  {
  RegOption('MN_TrendCCI_Period', ot_integer, MN_TrendCCI_Period);
  MN_TrendCCI_Period := 14;
  RegOption('MN_EntryCCI_Period', ot_integer, MN_EntryCCI_Period);
  MN_EntryCCI_Period := 6;
  }
  // 
  AddLevel(100, psSolid, 1, clGray);
  AddLevel(180, psSolid, 1, clGray);
  AddLevel(250, psSolid, 1, clGray);
  AddLevel(350, psSolid, 1, clGray);
  AddLevel(-100, psSolid, 1, clGray);
  AddLevel(-180, psSolid, 1, clGray);
  AddLevel(-250, psSolid, 1, clGray);
  AddLevel(-350, psSolid, 1, clGray);


  //   
  TrendCCI:= CreateIndexBuffer;
  EntryCCI:= CreateIndexBuffer;
  CCITrendUp:= CreateIndexBuffer;
  CCITrendDown:= CreateIndexBuffer;
  CCINoTrend:= CreateIndexBuffer;
  CCITimeBar:= CreateIndexBuffer;
  ZeroLine:= CreateIndexBuffer;

  IndicatorBuffers(7);

  SetIndexBuffer(0, CCITrendUp);
  SetIndexStyle (0, ds_Histogram, psSolid, 1, clLime);
  SetEmptyValue (0.0);
  SetIndexLabel (0, 'TrendUp');
  SetIndexBuffer(1, CCITrendDown);
  SetIndexStyle (1, ds_Histogram, psSolid, 1, clRed);
  SetEmptyValue (0.0);
  SetIndexLabel (1, 'TrendDown');
  SetIndexBuffer(2, CCINoTrend);
  SetIndexStyle (2, ds_Histogram, psSolid, 1, clWhite);
  SetEmptyValue (0.0);
  SetIndexLabel (2, 'No_Trend');
  SetIndexBuffer(3, CCITimeBar);
  SetIndexStyle (3, ds_Histogram, psSolid, 1, clYellow);
  SetEmptyValue (0.0);
  SetIndexLabel (3, 'TimeBar');
  SetIndexBuffer(4, TrendCCI);
  SetIndexStyle (4, ds_Line, psSolid, 2, clGreen);
  SetEmptyValue (0.0);
  SetIndexLabel (4, 'TrendCCI');
  SetIndexBuffer(5, EntryCCI);
  SetIndexStyle (5, ds_Line, psSolid, 2, clMaroon);
  SetEmptyValue (0.0);
  SetIndexLabel (5, 'EntryCCI');
  SetIndexBuffer(6, ZeroLine);
  SetIndexStyle (6, ds_Line, psSolid, 2, clBlue);
  SetEmptyValue (0.0);

  MATCCIBuffer:= CreateIndexBuffer;
  MAECCIBuffer:= CreateIndexBuffer;

end;

//---------------------------------------------------------------------------
//  
//---------------------------------------------------------------------------

procedure Done; stdcall;
begin
  // .  
end;


//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//    
//---------------------------------------------------------------------------

procedure Calculate(index: integer); stdcall;
var
  // 
  first, newBar: boolean;
  LastTime :TDateTime;

  //      
  LastBarsCount: integer;

  //  
  trendUp, TrendDown :integer;
  aTrendCCI, aEntryCCI :integer;

  //  
  i: Integer;
  sum: double;

  res: Real;

  //------------------------------------------------------------------
  //    
  //------------------------------------------------------------------
  function tprice(i: integer): double;
  begin
    result := (High(i) + Low(i) + Close(i))/3;
  end;




  //------------------------------------------------------------------
  //   
  //------------------------------------------------------------------
procedure MainLoop;
var j :integer;
begin
  if aTrendCCI > aEntryCCI then
    i:=Bars - aTrendCCI
  else
    i:=Bars - aEntryCCI;

  while i>=0 do begin
    MATCCIBuffer[i] := 0;
    MAECCIBuffer[i] := 0;
    CCINoTrend[i]   := 0;
    CCITrendDown[i] := 0;
    CCITimeBar[i]   := 0;
    CCITrendUp[i]   := 0;
    ZeroLine[i]     := 0;
    //------------------------------------------------------------------
    // TrendCCI Calc
    sum := 0;
    for j := 0 to aTrendCCI - 1 do
        sum := sum + tprice(i + j);

    MATCCIbuffer[i] := sum/aTrendCCI;

    sum := 0;
    for j := 0 to aTrendCCI - 1 do
        sum := sum + abs(tprice(j + i) - MATCCIbuffer[j + i]);

    TrendCCI[i] := (tprice(i) - MATCCIbuffer[i])/0.015/(sum/aTrendCCI);
    
    //------------------------------------------------------------------
    // EntryCCI Calc
    sum := 0;
    for j := 0 to aEntryCCI - 1 do
        sum := sum + tprice(i + j);

    MAECCIbuffer[i] := sum/aEntryCCI;

    sum := 0;
    for j := 0 to aEntryCCI - 1 do
        sum := sum + abs(tprice(j + i) - MAECCIbuffer[j + i]);

    EntryCCI[i] := (tprice(i) - MAECCIbuffer[i])/0.015/(sum/aEntryCCI);
    //------------------------------------------------------------------

    if(TrendCCI[i] > 0) and (TrendCCI[i+1] < 0) then
      begin
         if (trendDown > 4) then trendUp := 0;
      end;
    if (TrendCCI[i] > 0) then begin
       if (trendUp < 5) then begin
            CCINoTrend[i] := TrendCCI[i];
            trendUp:=trendUp+1;
       end;
       if (trendUp = 5) then begin
            CCITimeBar[i] := TrendCCI[i];
            trendUp:=trendUp+1;
       end ;
       if (trendUp > 5) then begin
            CCITrendUp[i] := TrendCCI[i];
       end;
    end;
    if(TrendCCI[i] < 0) and (TrendCCI[i+1] > 0) then begin
         if (trendUp > 4) then  trendDown := 0;
    end;
    if (TrendCCI[i] < 0) then begin
       if (trendDown < 5)then begin
            CCINoTrend[i] := TrendCCI[i];
            trendDown:=trendDown+1;
       end;
       if (trendDown = 5) then begin
            CCITimeBar[i] := TrendCCI[i];
            trendDown:=trendDown+1;
       end;
       if (trendDown > 5) then begin
            CCITrendDown[i] := TrendCCI[i];
       end;
    end ;

    //Print(format('SAR: %.4f, %d, %s, %.4f, %.4f, %.4f, %.4f  ', [SAR[i],i, DateTimetoStr(time(i)),SRp, CurPR, CurHigh, CurLow]));
    i:=i-1;
  end;
  LastBarsCount:=Bars;     // -     
end;

  //------------------------------------------------------------------
  //------------------------------------------------------------------
procedure CurrentBarCheck;
var j:integer;
begin
     //------------------------------------------------------------------
    // TrendCCI Calc
    sum := 0;
    for j := 0 to aTrendCCI - 1 do
        sum := sum + tprice( j);

    MATCCIbuffer[0] := sum/aTrendCCI;

    sum := 0;
    for j := 0 to aTrendCCI - 1 do
        sum := sum + abs(tprice(j) - MATCCIbuffer[j]);

    TrendCCI[0] := (tprice(0) - MATCCIbuffer[0])/0.015/(sum/aTrendCCI);
    
    //------------------------------------------------------------------
    // EntryCCI Calc
    sum := 0;
    for j := 0 to aEntryCCI - 1 do
        sum := sum + tprice(j);

    MAECCIbuffer[0] := sum/aEntryCCI;

    sum := 0;
    for j := 0 to aEntryCCI - 1 do
        sum := sum + abs(tprice(j) - MAECCIbuffer[j]);

    EntryCCI[0] := (tprice(0) - MAECCIbuffer[0])/0.015/(sum/aEntryCCI);
    //------------------------------------------------------------------

    if(TrendCCI[0] > 0) and (TrendCCI[1] < 0) then
      begin
         if (trendDown > 4) then trendUp := 0;
      end;
    if (TrendCCI[0] > 0) then begin
       if (trendUp < 5) then begin
            CCINoTrend[0] := TrendCCI[0];
            trendUp:=trendUp+1;
       end;
       if (trendUp = 5) then begin
            CCITimeBar[0] := TrendCCI[0];
            trendUp:=trendUp+1;
       end ;
       if (trendUp > 5) then begin
            CCITrendUp[0] := TrendCCI[0];
       end;
    end;
    if(TrendCCI[i] < 0) and (TrendCCI[1] > 0) then begin
         if (trendUp > 4) then  trendDown := 0;
    end;
    if (TrendCCI[0] < 0) then begin
       if (trendDown < 5)then begin
            CCINoTrend[0] := TrendCCI[0];
            trendDown:=trendDown+1;
       end;
       if (trendDown = 5) then begin
            CCITimeBar[0] := TrendCCI[0];
            trendDown:=trendDown+1;
       end;
       if (trendDown > 5) then begin
            CCITrendDown[0] := TrendCCI[0];
       end;
    end ;
end;
  //------------------------------------------------------------------


  //------------------------------------------------------------------
  //   
  //------------------------------------------------------------------
begin
  first:=true;
  newBar:=False;
  LastTime:=0;

  if index<>0 then exit;
  res:=0;

  if Automatic_Timeframe_Setting then begin
   if TimeFrame = PERIOD_M1 then begin
     aTrendCCI:=M1_TrendCCI_Period;
     aEntryCCI:=M1_EntryCCI_Period;
   end;
   if TimeFrame = PERIOD_M5 then begin
     aTrendCCI:=M5_TrendCCI_Period;
     aEntryCCI:=M5_EntryCCI_Period;
   end;
   if TimeFrame = PERIOD_M15 then begin
     aTrendCCI:=M15_TrendCCI_Period;
     aEntryCCI:=M15_EntryCCI_Period;
   end;   {
   if TimeFrame = PERIOD_M30 then begin
     TrendCCI:=M30_TrendCCI_Period;
     EntryCCI:=M30_EntryCCI_Period;
   end;    }
   if TimeFrame = PERIOD_H1 then begin
     aTrendCCI:=H1_TrendCCI_Period;
     aEntryCCI:=H1_EntryCCI_Period;
   end;
   if TimeFrame = PERIOD_H4 then begin
     aTrendCCI:=H4_TrendCCI_Period;
     aEntryCCI:=H4_EntryCCI_Period;
   end;
   if TimeFrame = PERIOD_D1 then begin
     aTrendCCI:=D1_TrendCCI_Period;
     aEntryCCI:=D1_EntryCCI_Period;
   end;
   if TimeFrame = PERIOD_W1 then begin
     aTrendCCI:=W1_TrendCCI_Period;
     aEntryCCI:=W1_EntryCCI_Period;
   end;
  end else begin
    atrendCCI := TrendCCI_Period;
    aentryCCI := EntryCCI_Period;
  end;
  IndicatorShortName('TrendCCI:' + IntToStr(aTrendCCI) + ', EntryCCI: ' + IntToStr(aEntryCCI)+' ');


  //------------------------------------------------------------------
  //      ,  ,   
  //    ,     . (  
  //     ).
  //------------------------------------------------------------------
  if Time(0)=LastTime then begin
   newbar:=false;
   CurrentBarCheck;
  end else newbar:=true;

  //               
  //          ( ) ,    
  if first or newbar or (LastBarsCount>Bars) then begin
    
    MainLoop;
    first:=false;
    newbar:=false;
  end;
end;
//----------------------------------------------------------------------


exports

//       

Init, Done, Calculate;



end.
//----------------------------------------------------------------------

