//---------------------------------------------------------------------------
// ATR
//---------------------------------------------------------------------------
library ATR;

uses
  SysUtils, Math, graphics, IndicatorInterfaceUnit, TechnicalFunctions;

var
  // External variables
  Period: integer;
  ApplyToPrice: integer;

  // Buffers
  ATRBuffer: TIndexBuffer;
  TempBuffer: TIndexBuffer;

//---------------------------------------------------------------------------
// Initialize indicator
//---------------------------------------------------------------------------
procedure Init; stdcall;
begin
  // define properties
  IndicatorShortName('Average True Range');
  SetOutputWindow(ow_SeparateWindow);

  // register options
  AddSeparator('Common');

  RegOption('Period', ot_Integer, Period);
  SetOptionRange('Period', 1, MaxInt);
  Period := 14;

  RegApplyToPriceOption(ApplyToPrice);

  // create buffers
  ATRBuffer := CreateIndexBuffer;
  TempBuffer := CreateIndexBuffer;

  IndicatorBuffers(1);
  SetIndexBuffer(0, ATRBuffer);
  SetIndexStyle(0, ds_Line, psSolid, 1, clRed);
  SetIndexLabel(0, 'ATR');
end;

//---------------------------------------------------------------------------
// Deinitialize indicator
//---------------------------------------------------------------------------
procedure Done; stdcall;
begin

end;

//---------------------------------------------------------------------------
// Calculate requested bar
//---------------------------------------------------------------------------
procedure Calculate(index: integer); stdcall;
var
  i: integer;
  P_High, P_Low, prevclose, sum: double;
begin
  P_High := High(index);
  P_Low := Low(index);
  if (index = Bars - 1) then
    TempBuffer[index] := P_High - P_Low
  else
    begin
      prevclose := GetPrice(index + 1, TPriceType(ApplyToPrice));
      TempBuffer[index] := Max(P_High, prevclose) - Min(P_Low, prevclose);
    end;

  sum:=0;
  for i:=0 to Period - 1 do
    sum := sum + TempBuffer[index + i];
  AtrBuffer[index] := sum/Period;
end;

exports

  Init, Done, Calculate;

end.
