//---------------------------------------------------------------------------
// Awesome Oscillator
//---------------------------------------------------------------------------
library AO;

uses
  graphics, IndicatorInterfaceUnit, TechnicalFunctions;

var
  // External variables
  periodF, periodS: integer;
  MAtype: integer;
  ApplyToPrice: integer;

  // Buffers
  SMA1, SMA2, SMAF, SMAS, SMA : TIndexBuffer;


//---------------------------------------------------------------------------
// Initialize indicator
//---------------------------------------------------------------------------
procedure Init; stdcall;
begin
  // define properties
  IndicatorShortName('Awesome Oscillator (B. Williams)');
  SetOutputWindow(ow_SeparateWindow);
  AddLevel(0, psDot, 1, cl_GridColor);
  SetEmptyValue(0);
  
  // register options
  AddSeparator('Common');

  RegOption('PeriodF', ot_Integer, periodF);
  SetOptionRange('PeriodF', 1, MaxInt);
  periodF := 5;

  RegOption('PeriodS', ot_Integer, periodS);
  SetOptionRange('PeriodF', 1, MaxInt);
  periodS := 34;

  RegMATypeOption(MAtype);

  RegApplyToPriceOption(ApplyToPrice);
  ApplyToPrice := 4;

  // create buffers
  SMA := CreateIndexBuffer;
  SMAF := CreateIndexBuffer;
  SMAS := CreateIndexBuffer;
  SMA1 := CreateIndexBuffer;
  SMA2 := CreateIndexBuffer;

  IndicatorBuffers(2);
  SetIndexBuffer(0, SMA1);
  SetIndexStyle(0, ds_Histogram, psSolid, 3, clLime);
  SetIndexLabel(0, 'SMA 1');
  SetIndexBuffer(1, SMA2);
  SetIndexStyle(1, ds_Histogram, psSolid, 3, clRed);
  SetIndexLabel(1, 'SMA 2');
end;

//---------------------------------------------------------------------------
// Deinitialize indicator
//---------------------------------------------------------------------------
procedure Done; stdcall;
begin

end;

//---------------------------------------------------------------------------
// Calculate requested bar
//---------------------------------------------------------------------------
procedure Calculate(index: integer); stdcall;
var
  current, prev: double;
begin
  if (index + PeriodF >= Bars) or (index + PeriodS >= Bars) then
    exit;

  SMAF[index] := GetMA(index, 0, PeriodF, TMAType(MAtype),
    TPriceType(ApplyToPrice), SMAF[index + 1]);

  SMAS[index] := GetMA(index, 0, PeriodS, TMAType(MAtype),
    TPriceType(ApplyToPrice), SMAS[index + 1]);

  SMA[index] := SMAF[index] -  SMAS[index];
  current := SMA[index];
  prev := SMA[index + 1];

  if(current < prev) then
    begin
      SMA2[index] := current;
      SMA1[index] := 0;
    end;

  if(current > prev) then
    begin
      SMA1[index] := current;
      SMA2[index] := 0;
    end;
end;

exports

Init, Done, Calculate;

end.



