//---------------------------------------------------------------------------
// Volume indicator
//---------------------------------------------------------------------------
library Volume;

uses
  graphics, IndicatorInterfaceUnit;

var
  // Buffers
  vol: TIndexBuffer;


//---------------------------------------------------------------------------
// Initialize indicator
//---------------------------------------------------------------------------
procedure Init; stdcall;
begin
  // define properties
  IndicatorShortName('Volume');
  SetOutputWindow(ow_SeparateWindow);
  AddLevel(0, psDot, 1, cl_GridColor);

  // create buffers
  vol := CreateIndexBuffer;

  IndicatorBuffers(1);
  SetIndexBuffer(0, vol);
  SetIndexStyle(0, ds_Histogram, psSolid, 1, clGreen);
  SetIndexLabel(0, 'Volume');
end;

//---------------------------------------------------------------------------
// Deinitialize indicator
//---------------------------------------------------------------------------
procedure Done; stdcall;
begin

end;

//---------------------------------------------------------------------------
// Calculate requested bar
//---------------------------------------------------------------------------
procedure Calculate(index: integer); stdcall;
begin
  vol[index] := IndicatorInterfaceUnit.volume(index);
end;

exports

Init, Done, Calculate;

end.
