//---------------------------------------------------------------------------
// Tom DeMark Range Expansions Index
//---------------------------------------------------------------------------
library TDREI;

uses
  SysUtils, Math, graphics, IndicatorInterfaceUnit, TechnicalFunctions;

var
  Period: integer;

  // Buffers
  buff: TIndexBuffer;
  buff1: TIndexBuffer;
  buff2: TIndexBuffer;


//---------------------------------------------------------------------------
// Initialize indicator
//---------------------------------------------------------------------------
procedure Init; stdcall;
begin
  // define properties
  IndicatorShortName('Range Expansions Index');
  SetOutputWindow(ow_SeparateWindow);
  IndicatorDigits(2);
  SetEmptyValue(0.001);
  //SetFixedMinMaxValues(-5, 105);
  AddLevel(45, psDot, 1, cl_GridColor);
  AddLevel(-45, psDot, 1, cl_GridColor);

  // register options
  AddSeparator('Common');

  RegOption('Period', ot_Integer, Period);
  SetOptionRange('Period', 1, MaxInt);
  Period := 5;

  // create buffers
  buff := CreateIndexBuffer;
  buff1 := CreateIndexBuffer;
  buff2 := CreateIndexBuffer;

  IndicatorBuffers(1);
  SetIndexBuffer(0, buff);
  SetIndexStyle(0, ds_Line, psSolid, 2, clRed);
  SetIndexLabel(0, 'Tom DeMark REI');
end;

//---------------------------------------------------------------------------
// Deinitialize indicator
//---------------------------------------------------------------------------
procedure Done; stdcall;
begin

end;

//---------------------------------------------------------------------------
// Calculate requested bar
//---------------------------------------------------------------------------
procedure Calculate(index: integer); stdcall;
var
  i: integer;
  sum1, sum2: double;
begin
  if index + 8 >= Bars then
    exit;

  if ((High(index) >= Low(index + 5)) or (High(index) >= Low(index + 6)) and
      (Low(index) <= High(index + 5)) or (Low(index) <= High(index + 6))) or
     ((High(index + 2) >= Close(index + 7)) or (High(index + 2) >= Close(index + 8)) and
      (Low(index + 2) <= Close(index + 7)) or (Low(index + 2) <= Close(index + 8))) then
    begin
      buff1[index] := High(index) - High(index + 2) + Low(index) - Low(index + 2);
      buff2[index] := abs(High(index) - High(index + 2)) + abs(Low(index) - Low(index + 2));
    end
  else
    begin
      buff1[index] := 0;
      buff2[index] := 0;
    end;

  sum1 := 0;
  sum2 := 0;
  for i:=0 to Period - 1 do
    begin
      sum1 := sum1 + buff1[index + i];
      sum2 := sum2 + buff2[index + i];
    end;

  try
    buff[index] := sum1/sum2*100;
  except
    buff[index] := 0;
  end;

end;

exports

  Init, Done, Calculate;

end.
