//---------------------------------------------------------------------------
// Polarized Fractal Efficiency (PFE)
//---------------------------------------------------------------------------
library PFE;

uses
  SysUtils, Math, graphics, IndicatorInterfaceUnit, TechnicalFunctions;

var
  // External variables
  Period: integer;
  ApplyToPrice: integer;

  // Buffers
  PFEBuffer: TIndexBuffer;
  EMABuffer: TIndexBuffer;

//---------------------------------------------------------------------------
// Initialize indicator
//---------------------------------------------------------------------------
procedure Init; stdcall;
begin
  // define properties
  IndicatorShortName('Polarized Fractal Efficiency (PFE)');
  SetOutputWindow(ow_SeparateWindow);
  AddLevel(0, psDot, 1, cl_GridColor);
  AddLevel(50, psDot, 1, cl_GridColor);
  AddLevel(-50, psDot, 1, cl_GridColor);

  // register options
  AddSeparator('Common');

  RegOption('Period', ot_Integer, Period);
  SetOptionRange('Period', 1, MaxInt);
  Period := 14;

  RegApplyToPriceOption(ApplyToPrice);

  // create buffers
  PFEBuffer := CreateIndexBuffer;
  EMABuffer := CreateIndexBuffer;

  IndicatorBuffers(1);
  SetIndexBuffer(0, EMABuffer);
  SetIndexStyle(0, ds_Line, psSolid, 2, clRed);
  SetIndexLabel(0, 'PFE');
end;

//---------------------------------------------------------------------------
// Deinitialize indicator
//---------------------------------------------------------------------------
procedure Done; stdcall;
begin

end;

//---------------------------------------------------------------------------
// Calculate requested bar
//---------------------------------------------------------------------------
procedure Calculate(index: integer); stdcall;
var
  a, b, k, prev: double;

  function price(offs: integer): double;
  begin
    result := GetPrice(index + offs, TPriceType(ApplyToPrice));
  end;

  function roc(count: integer): double;
  begin
    try
      result := ((price(0) - price(count))/price(count))*100;
    except
      result := 0;
    end;
  end;

begin
  if index + period + 1 >= Bars then
    exit;

  a := abs(roc(period));
  b := abs(roc(1));

  try
    if price(0) > price(period) then
      PFEBuffer[index] := Sqrt(sqr(a) + 100)/(Sqrt(sqr(b) + 1) + period)
    else
      PFEBuffer[index] := -Sqrt(sqr(a) + 100)/(Sqrt((sqr(b) + 1)) + period);
  except
    PFEBuffer[index] := 0;
  end;

  PFEBuffer[index] := PFEBuffer[index]*100;

  k := 2/(period + 1);
  prev := EMABuffer[index + 1];
  if prev = 0 then
    EMABuffer[index] := PFEBuffer[index]
  else
    EMABuffer[index] := prev + k*(PFEBuffer[index] - prev);
end;

exports

  Init, Done, Calculate;

end.
