//---------------------------------------------------------------------------
// OBV - On Balance Volume Indicator
// Written by Oleg Polovinkin
// Version 0.1
//---------------------------------------------------------------------------
library OBV;

uses
  SysUtils, Math, graphics, IndicatorInterfaceUnit, TechnicalFunctions;

var
  // external variables
  ApplyToPrice: integer;

  // Buffers
  OBVBuf: TIndexBuffer;

//---------------------------------------------------------------------------
// Initialize indicator
//---------------------------------------------------------------------------
procedure Init; stdcall;
begin
  // define properties
  IndicatorShortName('On Balance Volume (OBV)');
  SetOutputWindow(ow_SeparateWindow);

  RegApplyToPriceOption(ApplyToPrice);

  // create buffers
  OBVBuf := CreateIndexBuffer;

  IndicatorBuffers(1);
  SetIndexBuffer(0, OBVBuf);
  SetIndexStyle(0, ds_Line, psSolid, 2, clBlue);
  SetIndexLabel(0, 'OBV');
end;

//---------------------------------------------------------------------------
// Deinitialize indicator
//---------------------------------------------------------------------------
procedure Done; stdcall;
begin

end;

//---------------------------------------------------------------------------
// Calculate requested bar
//---------------------------------------------------------------------------
procedure Calculate(index: integer); stdcall;
var
  price0, price1: double;
begin
  // exclude last bar (we use index + 1)
  if (index >= Bars) then exit;

  price0 := GetPrice(index, TPriceType(ApplyToPrice));
  price1 := GetPrice(index + 1, TPriceType(ApplyToPrice));

  if (price0 > price1) then
    OBVBuf[index] := OBVBuf[index + 1] + Volume(index)
  else
    if (price0 < price1) then
      OBVBuf[index] := OBVBuf[index + 1] - Volume(index)
    else
      OBVBuf[index] := OBVBuf[index + 1];
end;

exports

  Init, Done, Calculate;

end.
