//---------------------------------------------------------------------------
// Ishimoku indicator
// translated by Koshelev M.A.
//---------------------------------------------------------------------------
library Ishimoku;

uses
  graphics, windows, IndicatorInterfaceUnit;

var
  // External variables
  TenkanSenPeriod: integer;
  KijunSenPeriod: integer;
  SenkouSpanPeriod: integer;

  // Buffers
  TenkanSen, KijunSen, ChinkouSpan, SenkouSpanA, SenkouSpanB: TIndexBuffer;


//---------------------------------------------------------------------------
// Initialize indicator
//---------------------------------------------------------------------------
procedure Init; stdcall;
begin
  // define properties
  IndicatorShortName('Ishimoku');
  SetOutputWindow(ow_ChartWindow);

  // register options
  AddSeparator('Common');

  RegOption('Tenkan-sen period', ot_Integer, TenkanSenPeriod);
  SetOptionRange('Tenkan-sen period', 1, MaxInt);
  TenkanSenPeriod := 9;

  RegOption('Kijun-sen period', ot_Integer, KijunSenPeriod);
  SetOptionRange('Kijun-sen period', 1, MaxInt);
  KijunSenPeriod := 26;

  RegOption('Senkou Span period', ot_Integer, SenkouSpanPeriod);
  SetOptionRange('Senkou Span period', 1, MaxInt);
  SenkouSpanPeriod := 52;

  // create buffers
  TenkanSen := CreateIndexBuffer;
  KijunSen := CreateIndexBuffer;
  ChinkouSpan := CreateIndexBuffer;
  SenkouSpanA := CreateIndexBuffer;
  SenkouSpanB := CreateIndexBuffer;

  IndicatorBuffers(5);
  SetIndexBuffer(0, TenkanSen);
  SetIndexBuffer(1, KijunSen);
  SetIndexBuffer(2, ChinkouSpan);
  SetIndexBuffer(3, SenkouSpanA);
  SetIndexBuffer(4, SenkouSpanB);
  SetIndexStyle(0, ds_Line, psSolid, 1, clRed);
  SetIndexLabel(0, 'Tenkan Sen');
  SetIndexStyle(1, ds_Line, psSolid, 1, clBlue);
  SetIndexLabel(1, 'Kijun Sen');
  SetIndexStyle(2, ds_Line, psSolid, 1, clGreen);
  SetIndexLabel(2, 'Chinkou Span');
  SetIndexStyle(3, ds_Line, psSolid, 1, RGB($FF, $AB, $79));
  SetIndexLabel(3, 'Senkou Span A');
  SetIndexStyle(4, ds_Fill, psSolid, 1, RGB($9E, $9E, $FF));
  SetIndexLabel(4, 'Senkou Span B');
end;

//---------------------------------------------------------------------------
// change parameters
//---------------------------------------------------------------------------
procedure OnParamsChange; stdcall;
begin
  SetBufferShift(2, -KijunSenPeriod);
  SetBufferShift(3, KijunSenPeriod);
  SetBufferShift(4, KijunSenPeriod);
end;

//---------------------------------------------------------------------------
// Calculate requested bar
//---------------------------------------------------------------------------
procedure Calculate(index: integer); stdcall;
var
  i: integer;
  h, l: double;
begin
  // calculate tenkan-sen
  h := High(index);
  l := Low(index);
  for i:=index + 1 to index + TenkanSenPeriod - 1 do
    begin
      if High(i) > h then
        h := High(i);
      if Low(i) < l then
        l := Low(i);
    end;
  TenkanSen[index] := (h + l)/2;

  // calculate kijun-sen
  h := High(index);
  l := Low(index);
  for i:=index + 1 to index + KijunSenPeriod - 1 do
    begin
      if High(i) > h then
        h := High(i);
      if Low(i) < l then
        l := Low(i);
    end;
  KijunSen[index] := (h + l)/2;

  // calculate chinkou-span
  ChinkouSpan[index] := Close(index);

  // calculate Senkou Span A
  SenkouSpanA[index] := (TenkanSen[index] + KijunSen[index])/2;

  // calculate Senkou Span B
  h := High(index);
  l := Low(index);
  for i:=index + 1 to index + SenkouSpanPeriod - 1 do
    begin
      if High(i) > h then
        h := High(i);
      if Low(i) < l then
        l := Low(i);
    end;
  SenkouSpanB[index] := (h + l)/2;
end;

exports

Init, OnParamsChange, Calculate;

end.
