//---------------------------------------------------------------------------
// Fractals indicator
//---------------------------------------------------------------------------
library Fractals;

uses
  graphics, IndicatorInterfaceUnit;

var
  // Buffers
  UpBuff, DownBuff: TIndexBuffer;


//---------------------------------------------------------------------------
// Initialize indicator
//---------------------------------------------------------------------------
procedure Init; stdcall;
begin
  // define properties
  IndicatorShortName('Fractals (B. Williams)');
  SetOutputWindow(ow_ChartWindow);

  // create buffers
  UpBuff := CreateIndexBuffer;
  DownBuff := CreateIndexBuffer;
  IndicatorBuffers(2);
  SetIndexBuffer(0, UpBuff);
  SetIndexBuffer(1, DownBuff);
  SetIndexStyle(0, ds_Symbol, psSolid, 1, clGray);
  SetIndexSymbol(0, 217, 0, 10);
  SetIndexLabel(0, 'Fractal Up');
  SetIndexStyle(1, ds_Symbol, psSolid, 1, clGray);
  SetIndexSymbol(1, 218, 0, -10);
  SetIndexLabel(1, 'Fractal Down');
end;

//---------------------------------------------------------------------------
// Deinitialize indicator
//---------------------------------------------------------------------------
procedure Done; stdcall;
begin

end;

//---------------------------------------------------------------------------
// Calculate requested bar
//---------------------------------------------------------------------------
procedure Calculate(index: integer); stdcall;
var
  condition1, condition2, condition3, condition4, condition5: boolean;
begin
  if Bars - Index < 10 then
    exit;

  Condition1 :=
   (High(index + 3) > High(index + 5)) and
   (High(index + 3) > High(index + 4)) and
   (High(index + 3) > High(index + 2)) and
   (High(index + 3) > High(index + 1));

  Condition2 :=
   (High(index + 4) > High(index + 6)) and
   (High(index + 4) > High(index + 5)) and
   (High(index + 4) = High(index + 3)) and
   (High(index + 3) > High(index + 2)) and
   (High(index + 3) > High(index + 1));

  Condition3 :=
   (High(index + 5) >  High(index + 7)) and
   (High(index + 5) >  High(index + 6)) and
   (High(index + 3) >= High(index + 5)) and
   (High(index + 4) <= High(index + 5)) and
   (High(index + 3) >= High(index + 4)) and
   (High(index + 3) >  High(index + 2)) and
   (High(index + 3) >  High(index + 1));

  Condition4 :=
   (High(index + 3) = High(index + 4)) and
   (High(index + 4) = High(index + 5)) and
   (High(index + 5) = High(index + 6)) and
   (High(index + 6) > High(index + 7)) and
   (High(index + 6) > High(index + 8)) and
   (High(index + 3) > High(index + 2)) and
   (High(index + 3) > High(index + 1));

  Condition5 :=
   (High(index + 3) = High(index + 4)) and
   (High(index + 4) = High(index + 5)) and
   (High(index + 5) = High(index + 6)) and
   (High(index + 6) = High(index + 7)) and
   (High(index + 7) > High(index + 8)) and
   (High(index + 7) > High(index + 9)) and
   (High(index + 3) > High(index + 2)) and
   (High(index + 3) > High(index + 1));

  if Condition1 or condition2 or Condition3 or Condition4 or Condition5 then
    UpBuff[index + 3] := High(index + 3)
  else
    UpBuff[index + 3] := 0;

  Condition1 :=
   (Low(index + 3) < Low(index + 5)) and
   (Low(index + 3) < Low(index + 4)) and
   (Low(index + 3) < Low(index + 2)) and
   (Low(index + 3) < Low(index + 1));

  Condition2 :=
   (Low(index + 4) < Low(index + 6)) and
   (Low(index + 4) < Low(index + 5)) and
   (Low(index + 4) = Low(index + 3)) and
   (Low(index + 3) < Low(index + 2)) and
   (Low(index + 3) < Low(index + 1));

  Condition3 :=
   (Low(index + 5) <  Low(index + 7)) and
   (Low(index + 5) <  Low(index + 6)) and
   (Low(index + 3) <= Low(index + 5)) and
   (Low(index + 4) <= Low(index + 5)) and
   (Low(index + 3) <= Low(index + 4)) and
   (Low(index + 3) <  Low(index + 2)) and
   (Low(index + 3) <  Low(index + 1));

  Condition4 :=
   (Low(index + 3) = Low(index + 4)) and
   (Low(index + 4) = Low(index + 5)) and
   (Low(index + 5) = Low(index + 6)) and
   (Low(index + 6) < Low(index + 7)) and
   (Low(index + 6) < Low(index + 8)) and
   (Low(index + 3) < Low(index + 2)) and
   (Low(index + 3) < Low(index + 1));

  Condition5 :=
   (Low(index + 3) = Low(index + 4)) and
   (Low(index + 4) = Low(index + 5)) and
   (Low(index + 5) = Low(index + 6)) and
   (Low(index + 6) = Low(index + 7)) and
   (Low(index + 7) < Low(index + 8)) and
   (Low(index + 7) < Low(index + 9)) and
   (Low(index + 3) < Low(index + 2)) and
   (Low(index + 3) < Low(index + 1));

  if Condition1 or condition2 or Condition3 or Condition4 or Condition5 then
    DownBuff[index + 3] := Low(index + 3)
  else
    DownBuff[index + 3] := 0;
end;

exports

Init, Done, Calculate;

end.
