library FATL;

uses
  SysUtils, Classes, graphics, IndicatorInterfaceUnit;

var
  // 
  FATLBuffer: TIndexBuffer;

//-------------------------------------
// 
//-------------------------------------
procedure Init; stdcall;
begin
  //  
  IndicatorShortName('FATL');
  SetOutputWindow(ow_ChartWindow);

  // 
  IndicatorBuffers(1);
  FATLBuffer := CreateIndexBuffer;
  SetIndexBuffer(0,FATLBuffer);
  SetIndexStyle(0, ds_Line, psSolid, 2, clYellow);
  SetIndexLabel(0, 'FATL');
end;

//---------------------------------------------------------------------------
//  
//---------------------------------------------------------------------------
procedure Done; stdcall;
begin

end;

//---------------------------------------------------------------------------
// Calculate requested bar
//---------------------------------------------------------------------------
procedure Calculate(index: integer); stdcall;
begin
  FATLBuffer[index] :=
    0.4360409450*Close(index + 0)
    +0.3658689069*Close(index + 1)
    +0.2460452079*Close(index + 2)
    +0.1104506886*Close(index + 3)
    -0.0054034585*Close(index + 4)
    -0.0760367731*Close(index + 5)
    -0.0933058722*Close(index + 6)
    -0.0670110374*Close(index + 7)
    -0.0190795053*Close(index + 8)
    +0.0259609206*Close(index + 9)
    +0.0502044896*Close(index + 10)
    +0.0477818607*Close(index + 11)
    +0.0249252327*Close(index + 12)
    -0.0047706151*Close(index + 13)
    -0.0272432537*Close(index + 14)
    -0.0338917071*Close(index + 15)
    -0.0244141482*Close(index + 16)
    -0.0055774838*Close(index + 17)
    +0.0128149838*Close(index + 18)
    +0.0226522218*Close(index + 19)
    +0.0208778257*Close(index + 20)
    +0.0100299086*Close(index + 21)
    -0.0036771622*Close(index + 22)
    -0.0136744850*Close(index + 23)
    -0.0160483392*Close(index + 24)
    -0.0108597376*Close(index + 25)
    -0.0016060704*Close(index + 26)
    +0.0069480557*Close(index + 27)
    +0.0110573605*Close(index + 28)
    +0.0095711419*Close(index + 29)
    +0.0040444064*Close(index + 30)
    -0.0023824623*Close(index + 31)
    -0.0067093714*Close(index + 32)
    -0.0072003400*Close(index + 33)
    -0.0047717710*Close(index + 34)
    +0.0005541115*Close(index + 35)
    +0.0007860160*Close(index + 36)
    +0.0130129076*Close(index + 37)
    +0.0040364019*Close(index + 38)
end;

exports

Init, Done, Calculate;

end.



