//---------------------------------------------------------------------------
// Envelopes
//---------------------------------------------------------------------------
library Envelopes;

uses
  graphics,
  IndicatorInterfaceUnit,
  TechnicalFunctions in 'TechnicalFunctions.pas';

var
  // External variables
  Deviation: double = 0.1;
  period: integer = 14;
  Shift: integer = 0;
  MAType: integer;
  ApplyToPrice: integer;

  // Buffers
  MA: TIndexBuffer;
  Env_UP: TIndexBuffer;
  Env_DOWN: TIndexBuffer;


//---------------------------------------------------------------------------
// Initialize indicator
//---------------------------------------------------------------------------
procedure Init; stdcall;
begin
  // define properties
  IndicatorShortName('Envelopes');
  SetOutputWindow(ow_ChartWindow);

  // register options
  AddSeparator('Common');

  RegOption('Period', ot_Integer, period);
  SetOptionRange('Period', 1, MaxInt);
  RegOption('Shift', ot_Integer, Shift);
  RegMATypeOption(MAType);
  MAType := 3;
  RegApplyToPriceOption(ApplyToPrice);
  RegOption('Deviation', ot_Double, Deviation);
  SetOptionRange('Deviation', 0.01, 100);

  Env_UP := CreateIndexBuffer;
  Env_DOWN := CreateIndexBuffer;
  MA := CreateIndexBuffer;

  // create buffers
  IndicatorBuffers(2);

  SetIndexBuffer(0, Env_UP);
  SetIndexStyle(0, ds_Line, psSolid, 1, clBlue);
  SetIndexLabel(0, 'Envelope Up');

  SetIndexBuffer(1, Env_DOWN);
  SetIndexStyle(1, ds_Line, psSolid, 1, clRed);
  SetIndexLabel(1, 'Envelope Down');
end;

//---------------------------------------------------------------------------
// parameters changed
//---------------------------------------------------------------------------
procedure OnParamsChange; stdcall;
begin
  SetBufferShift(0, Shift);
  SetBufferShift(1, Shift);
end;

//---------------------------------------------------------------------------
// Calculate requested bar
//---------------------------------------------------------------------------
procedure Calculate(index: integer); stdcall;
begin
  MA[index] := GetMA(index, 0, period, TMAType(MAtype), TPriceType(ApplyToPrice),
    MA[index + 1]);

  Env_UP[index]   := (1 + Deviation/100)*MA[index];
  Env_DOWN[index] := (1 - Deviation/100)*MA[index];
end;

exports

Init, OnParamsChange, Calculate;

end.
