//---------------------------------------------------------------------------
// Commodity Channel Index (CCI)
//---------------------------------------------------------------------------
library CCI;

uses
  graphics, windows, IndicatorInterfaceUnit;

var
  // external parameters
  CCIPeriod: integer;

  // Index buffers
  CCIBuffer, MAbuff: TIndexBuffer;


//---------------------------------------------------------------------------
// Initialization procedure
//---------------------------------------------------------------------------
procedure Init; stdcall;
begin
  // configure indicator
  IndicatorShortName('Commodity Channel Index (CCI)');
  SetOutputWindow(ow_SeparateWindow);
  AddLevel(-100, psDot, 1, cl_GridColor);
  AddLevel(100, psDot, 1, cl_GridColor);
  AddLevel(0, psDot, 1, cl_GridColor);
  SetEmptyValue(0.0001234);

  // register external parameters
  AddSeparator('Common');

  RegOption('CCI period', ot_Integer, CCIPeriod);
  SetOptionRange('CCI period', 1, MaxInt);
  CCIPeriod := 14;

  // Create index buffers
  MAbuff := CreateIndexBuffer;
  CCIBuffer := CreateIndexBuffer;

  IndicatorBuffers(1);
  SetIndexBuffer(0, CCIBuffer);
  SetIndexStyle(0, ds_line, psSolid, 1, RGB($1E, $90, $FF));
  SetIndexLabel(0, 'CCI');
end;

//---------------------------------------------------------------------------
// Deinitialization procedure
//---------------------------------------------------------------------------
procedure Done; stdcall;
begin
  // do nothing
end;

//---------------------------------------------------------------------------
// Calculate single bar
//---------------------------------------------------------------------------
procedure Calculate(index: integer); stdcall;
var
  sum: double;
  i: integer;

  function tprice(i: integer): double;
  begin
    result := (High(i) + Low(i) + Close(i))/3;
  end;

begin
  // count moving average
  sum := 0;
  for i := 0 to CCIPeriod - 1 do
    sum := sum + tprice(index + i);

  MAbuff[index] := sum/CCIPeriod;

  if index + CCIPeriod >= Bars then
    exit;

  sum := 0;
  for i := 0 to CCIPeriod - 1 do
    sum := sum + abs(tprice(index + i) - MAbuff[index]);

  if sum = 0 then
    CCIBuffer[index] := CCIBuffer[index + 1]
  else
    CCIBuffer[index] := (tprice(index) - MAbuff[index])/0.015/(sum/CCIPeriod);
end;

exports

Init, Done, Calculate;

end.

